/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.relationship;

import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.SubmodelElementXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.relationship.IRelationshipElement;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.RelationshipElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.RelationshipElementValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RelationshipElementXMLConverter
extends SubmodelElementXMLConverter {
    public static final String RELATIONSHIP_ELEMENT = "aas:relationshipElement";
    public static final String FIRST = "aas:first";
    public static final String SECOND = "aas:second";

    public static RelationshipElement parseRelationshipElement(Map<String, Object> xmlObject) {
        RelationshipElement relElement = new RelationshipElement();
        RelationshipElementXMLConverter.populateRelationshipElement(xmlObject, relElement);
        return relElement;
    }

    public static void populateRelationshipElement(Map<String, Object> xmlObject, IRelationshipElement relElement) {
        Map firstMap = (Map)xmlObject.get(FIRST);
        Reference first = ReferenceXMLConverter.parseReference(firstMap);
        Map secondMap = (Map)xmlObject.get(SECOND);
        Reference second = ReferenceXMLConverter.parseReference(secondMap);
        relElement.setValue(new RelationshipElementValue(first, second));
        RelationshipElementXMLConverter.populateSubmodelElement(xmlObject, relElement);
    }

    public static Element buildRelationshipElement(Document document, IRelationshipElement relElem) {
        Element relElemRoot = document.createElement(RELATIONSHIP_ELEMENT);
        RelationshipElementXMLConverter.populateRelationshipElement(document, relElemRoot, relElem);
        return relElemRoot;
    }

    public static void populateRelationshipElement(Document document, Element root, IRelationshipElement relElem) {
        IReference second;
        RelationshipElementXMLConverter.populateSubmodelElement(document, root, relElem);
        RelationshipElementValue value = relElem.getValue();
        IReference first = value.getFirst();
        if (first != null) {
            Element derivedFromRoot = document.createElement(FIRST);
            derivedFromRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, first));
            root.appendChild(derivedFromRoot);
        }
        if ((second = value.getSecond()) != null) {
            Element derivedFromRoot = document.createElement(SECOND);
            derivedFromRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, second));
            root.appendChild(derivedFromRoot);
        }
    }
}

