/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.dataelement;

import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.SubmodelElementXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IBlob;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.Blob;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BlobXMLConverter
extends SubmodelElementXMLConverter {
    public static final String BLOB = "aas:blob";

    public static Blob parseBlob(Map<String, Object> xmlObject) {
        String mimeType = XMLHelper.getString(xmlObject.get("aas:mimeType"));
        String value = XMLHelper.getString(xmlObject.get("aas:value"));
        Blob blob = new Blob();
        blob.setMimeType(mimeType);
        blob.setValue(value);
        BlobXMLConverter.populateSubmodelElement(xmlObject, blob);
        return blob;
    }

    public static Element buildBlob(Document document, IBlob blob) {
        Element blobRoot = document.createElement(BLOB);
        BlobXMLConverter.populateSubmodelElement(document, blobRoot, blob);
        String value = blob.getValue();
        String mimeType = blob.getMimeType();
        if (value != null) {
            Element valueRoot = document.createElement("aas:value");
            valueRoot.appendChild(document.createTextNode(value));
            blobRoot.appendChild(valueRoot);
        }
        if (mimeType != null) {
            Element mimeTypeRoot = document.createElement("aas:mimeType");
            mimeTypeRoot.appendChild(document.createTextNode(mimeType));
            blobRoot.appendChild(mimeTypeRoot);
        }
        return blobRoot;
    }
}

