/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Qualifiable;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueTypeHelper;
import org.eclipse.basyx.vab.exception.provider.ProviderException;

public class Property
extends DataElement
implements IProperty {
    public static final String VALUE = "value";
    public static final String VALUEID = "valueId";
    public static final String VALUETYPE = "valueType";
    public static final String MODELTYPE = "Property";

    public Property() {
        this.putAll(new ModelType(MODELTYPE));
        this.put(VALUE, null);
        this.put(VALUEID, null);
    }

    public Property(String idShort, ValueType valueType) {
        super(idShort);
        this.setValueType(valueType);
        this.setIdShort(idShort);
        this.putAll(new ModelType(MODELTYPE));
    }

    public Property(String idShort, Object value) {
        this.setIdShort(idShort);
        this.putAll(new ModelType(MODELTYPE));
        this.setValue(value);
    }

    public static Property createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Property.isValid(obj)) {
            throw new MetamodelConstructionException(Property.class, obj);
        }
        Property facade = new Property();
        facade.setMap(obj);
        return facade;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return DataElement.isValid(obj) && obj.containsKey(VALUETYPE);
    }

    public static boolean isProperty(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey(VALUE) && map.containsKey(VALUETYPE);
    }

    public Property(Object value) {
        this();
        this.put(VALUEID, null);
        this.setValue(value);
    }

    public Property(Object value, Referable referable, Reference semanticId, Qualifiable qualifiable) {
        this(value);
        this.putAll(referable);
        this.put("semanticId", semanticId);
        this.putAll(qualifiable);
    }

    public void setValueType(ValueType type) {
        if (type == null) {
            throw new RuntimeException("Can not set null as valueType");
        }
        this.put(VALUETYPE, type.toString());
    }

    public void setValueId(IReference ref) {
        Reference refMap = new Reference();
        refMap.setKeys(ref.getKeys());
        this.put(VALUEID, refMap);
    }

    @Override
    public IReference getValueId() {
        return Reference.createAsFacade((Map)this.get(VALUEID));
    }

    public void set(Object newValue, ValueType newType) throws ProviderException {
        this.put(VALUE, newValue);
        this.setValueType(newType);
    }

    @Override
    public ValueType getValueType() {
        String valueType = (String)this.get(VALUETYPE);
        if (valueType == null) {
            return null;
        }
        return ValueTypeHelper.fromName(valueType);
    }

    public void addConceptDescription(IConceptDescription description) {
        Reference ref = new Reference(description, KeyElements.CONCEPTDESCRIPTION, true);
        this.setSemanticId(ref);
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.PROPERTY;
    }

    @Override
    public Object getValue() {
        Object value = this.get(VALUE);
        if (value instanceof String) {
            return ValueTypeHelper.getJavaObject(value, this.getValueType());
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
        this.put(VALUE, ValueTypeHelper.prepareForSerialization(value));
        if (this.getValueType() == null) {
            if (value == null) {
                throw new RuntimeException("Can not set mandatory attribute 'valueType' with null as value");
            }
            this.put(VALUETYPE, ValueTypeHelper.getType(value).toString());
        }
    }

    @Override
    public Property getLocalCopy() {
        Property copy = new Property();
        copy.putAll(this);
        return copy;
    }
}

