/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.sqlproxy;

import java.sql.ResultSet;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.tools.sql.driver.ISQLDriver;
import org.eclipse.basyx.tools.sql.query.DynamicSQLQuery;
import org.eclipse.basyx.tools.sql.query.DynamicSQLUpdate;
import org.eclipse.basyx.tools.sqlproxy.SQLProxy;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.eclipse.basyx.tools.sqlproxy.SQLTableRow;

public class SQLMap
extends SQLProxy
implements Map<String, Object> {
    public SQLMap(SQLRootElement rootElement, int tableId) {
        super(rootElement.getDriver(), rootElement.getSqlTableID() + "__" + tableId, rootElement);
    }

    public SQLMap(SQLRootElement rootElement, String tableIdWithprefix) {
        super(rootElement.getDriver(), tableIdWithprefix, rootElement);
    }

    public SQLMap(SQLRootElement rootElement, Map<String, Object> other) {
        this(rootElement, SQLMap.createMapTable(rootElement));
        for (Map.Entry<String, Object> entry : other.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private static int createMapTable(SQLRootElement rootElement) {
        int tableId = rootElement.getNextIdentifier();
        rootElement.createMap(tableId);
        return tableId;
    }

    @Override
    public int size() {
        String queryString = "SELECT * FROM elements." + this.getSqlTableID();
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(this.getDriver(), queryString, "mapArray(name:String,value:String,type:String)");
        ResultSet result = dynQuery.getRaw();
        return this.getSize(result);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(this.getDriver(), key);
    }

    protected boolean containsKey(ISQLDriver drv, Object key) {
        String queryString = "SELECT * FROM elements." + this.getSqlTableID() + " WHERE name='$name'";
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(drv, queryString, "mapArray(name:String,value:String,type:String)");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("name", key);
        ResultSet result = dynQuery.getRaw(parameter);
        return this.getSize(result) > 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(this.getDriver(), value);
    }

    protected boolean containsValue(ISQLDriver drv, Object value) {
        String queryString = "SELECT * FROM elements." + this.getSqlTableID() + " WHERE value='$value'";
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(drv, queryString, "mapArray(name:String,value:String,type:String)");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("value", SQLTableRow.getValueAsString(value));
        ResultSet result = dynQuery.getRaw(parameter);
        return this.getSize(result) > 0;
    }

    @Override
    public Object get(Object key) {
        return this.getValueFromMap(this.getSqlTableID(), key.toString());
    }

    @Override
    public Object put(String key, Object value) {
        this.putValue(this.getDriver(), key, value);
        return value;
    }

    protected void putValue(ISQLDriver sqlDrv, String key, Object value) {
        value = this.convertToSimpleValue(value);
        this.putSimpleValue(sqlDrv, key, value);
    }

    private void putSimpleValue(ISQLDriver sqlDrv, String key, Object value) {
        if (this.containsKey(sqlDrv, key)) {
            this.updateInMapSimple(sqlDrv, this.getSqlTableID(), new SQLTableRow(key, value));
        } else {
            this.addToMapSimple(sqlDrv, this.getSqlTableID(), new SQLTableRow(key, value));
        }
    }

    private Object convertToSimpleValue(Object value) {
        if (!(!(value instanceof Map) || value instanceof SQLMap && ((SQLMap)value).sqlRootElement.getSqlTableID().equals(this.sqlRootElement.getSqlTableID()))) {
            return new SQLMap(this.sqlRootElement, (Map)value);
        }
        return value;
    }

    @Override
    public Object remove(Object key) {
        Object result = null;
        result = this.getValueFromMap(this.getDriver(), this.getSqlTableID(), key.toString());
        String updateString = "DELETE FROM elements." + this.getSqlTableID() + " WHERE name='$name'";
        DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(this.getDriver(), updateString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("name", key);
        dynUpdate.accept((Map<String, Object>)parameter);
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.removeAllKeys(this.getDriver(), map.keySet());
        LinkedList<SQLTableRow> mapElements = new LinkedList<SQLTableRow>();
        for (String string : map.keySet()) {
            mapElements.add(new SQLTableRow(string, map.get(string)));
        }
        this.addToMapMultiple(this.getDriver(), this.getSqlTableID(), mapElements);
    }

    @Override
    public void clear() {
        String updateString = "DELETE FROM elements." + this.getSqlTableID();
        DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(this.getDriver(), updateString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynUpdate.accept((Map<String, Object>)parameter);
    }

    @Override
    public Set<String> keySet() {
        return (Set)this.getSingleMapColumnRaw(this.getSqlTableID(), "name");
    }

    @Override
    public Collection<Object> values() {
        List sqlResult = (List)this.getMapColumnRaw(this.getSqlTableID(), "type", "value");
        LinkedList<Object> result = new LinkedList<Object>();
        for (Map singleResult : sqlResult) {
            result.add(SQLTableRow.getValueFromString(this.sqlRootElement, Integer.parseInt((String)singleResult.get("type")), (String)singleResult.get("value")));
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        List sqlResult = (List)this.getMapColumnRaw(this.getSqlTableID(), "name", "type", "value");
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
        for (Map singleResult : sqlResult) {
            Object value = SQLTableRow.getValueFromString(this.sqlRootElement, Integer.parseInt((String)singleResult.get("type")), (String)singleResult.get("value"));
            AbstractMap.SimpleEntry<String, Object> resultEntry = new AbstractMap.SimpleEntry<String, Object>((String)singleResult.get("name"), value);
            result.add(resultEntry);
        }
        return result;
    }
}

