/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.xml;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.basyx.aas.factory.xml.api.parts.AssetXMLConverter;
import org.eclipse.basyx.aas.factory.xml.converters.AssetAdministrationShellXMLConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.submodel.factory.xml.api.parts.ConceptDescriptionXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.SubmodelXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.vab.factory.xml.XmlParser;
import org.xml.sax.SAXException;

public class XMLToMetamodelConverter {
    private Map<String, Object> root = new HashMap<String, Object>();

    public XMLToMetamodelConverter(String xmlContent) throws ParserConfigurationException, SAXException, IOException {
        this.root.putAll((Map)XmlParser.buildXmlMap(xmlContent).get("aas:aasenv"));
    }

    public List<IAssetAdministrationShell> parseAAS() throws ParserConfigurationException, SAXException, IOException {
        Map xmlAASs = (Map)this.root.get("aas:assetAdministrationShells");
        List<IConceptDescription> conceptDescriptions = this.parseConceptDescriptions();
        return AssetAdministrationShellXMLConverter.parseAssetAdministrationShells(xmlAASs, conceptDescriptions);
    }

    public List<IAsset> parseAssets() throws ParserConfigurationException, SAXException, IOException {
        Map xmlAssets = (Map)this.root.get("aas:assets");
        return AssetXMLConverter.parseAssets(xmlAssets);
    }

    public List<ISubmodel> parseSubmodels() {
        Map xmlSubmodels = (Map)this.root.get("aas:submodels");
        return SubmodelXMLConverter.parseSubmodels(xmlSubmodels);
    }

    public List<IConceptDescription> parseConceptDescriptions() {
        Map xmlConceptDescriptions = (Map)this.root.get("aas:conceptDescriptions");
        return ConceptDescriptionXMLConverter.parseConceptDescriptions(xmlConceptDescriptions);
    }
}

