/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.api.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.HasDataSpecificationXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.IdentifiableXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.parts.ConceptDescription;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Identifiable;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConceptDescriptionXMLConverter {
    public static final String CONCEPT_DESCRIPTIONS = "aas:conceptDescriptions";
    public static final String CONCEPT_DESCRIPTION = "aas:conceptDescription";
    public static final String IS_CASE_OF = "aas:isCaseOf";

    public static List<IConceptDescription> parseConceptDescriptions(Map<String, Object> xmlObject) {
        List<Map<String, Object>> xmlConceptDescriptionList = XMLHelper.getList(xmlObject.get(CONCEPT_DESCRIPTION));
        ArrayList<IConceptDescription> conceptDescriptions = new ArrayList<IConceptDescription>();
        for (Map<String, Object> xmlConceptDescription : xmlConceptDescriptionList) {
            ConceptDescription conceptDescription = new ConceptDescription();
            IdentifiableXMLConverter.populateIdentifiable(xmlConceptDescription, Identifiable.createAsFacadeNonStrict(conceptDescription, KeyElements.CONCEPTDESCRIPTION));
            HasDataSpecificationXMLConverter.populateHasDataSpecification(xmlConceptDescription, HasDataSpecification.createAsFacade(conceptDescription));
            Collection<Reference> handleIsCaseOf = ConceptDescriptionXMLConverter.parseIsCaseOfRefs(xmlConceptDescription);
            conceptDescription.setIsCaseOf(handleIsCaseOf);
            conceptDescriptions.add(conceptDescription);
        }
        return conceptDescriptions;
    }

    private static Collection<Reference> parseIsCaseOfRefs(Map<String, Object> xmlObject) {
        HashSet<Reference> references = new HashSet<Reference>();
        List<Map<String, Object>> xmlKeyList = XMLHelper.getList(xmlObject.get(IS_CASE_OF));
        for (Map<String, Object> xmlKey : xmlKeyList) {
            references.add(ReferenceXMLConverter.parseReference(xmlKey));
        }
        return references;
    }

    public static Element buildConceptDescriptionsXML(Document document, Collection<IConceptDescription> conceptDescriptions) {
        Element root = document.createElement(CONCEPT_DESCRIPTIONS);
        ArrayList<Element> xmlConceptDescriptionList = new ArrayList<Element>();
        for (IConceptDescription conceptDescription : conceptDescriptions) {
            Element conceptDescriptionRoot = document.createElement(CONCEPT_DESCRIPTION);
            IdentifiableXMLConverter.populateIdentifiableXML(document, conceptDescriptionRoot, conceptDescription);
            HasDataSpecificationXMLConverter.populateHasDataSpecificationXML(document, conceptDescriptionRoot, conceptDescription);
            ConceptDescriptionXMLConverter.buildIsCaseOf(document, conceptDescriptionRoot, conceptDescription);
            xmlConceptDescriptionList.add(conceptDescriptionRoot);
        }
        for (Element element : xmlConceptDescriptionList) {
            root.appendChild(element);
        }
        return root;
    }

    private static void buildIsCaseOf(Document document, Element xmlConceptDescription, IConceptDescription conceptDescription) {
        Collection<IReference> references = conceptDescription.getIsCaseOf();
        Element xmlIsCaseOf = document.createElement(IS_CASE_OF);
        Element keysElement = ReferenceXMLConverter.buildReferencesXML(document, references);
        if (keysElement != null) {
            xmlIsCaseOf.appendChild(keysElement);
            xmlConceptDescription.appendChild(xmlIsCaseOf);
        }
    }
}

