/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.aasx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.xml.XMLAASBundleFactory;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IFile;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AASXPackageManager {
    private static final String XML_TYPE = "http://www.admin-shell.io/aasx/relationships/aas-spec";
    private static final String AASX_ORIGIN = "/aasx/aasx-origin";
    private String aasxPath;
    private XMLAASBundleFactory bundleFactory;
    private Set<AASBundle> bundles;
    private static Logger logger = LoggerFactory.getLogger(AASXPackageManager.class);

    public AASXPackageManager(String path) {
        this.aasxPath = path;
    }

    public Set<AASBundle> retrieveAASBundles() throws IOException, ParserConfigurationException, SAXException, InvalidFormatException {
        if (this.bundles != null) {
            return this.bundles;
        }
        OPCPackage aasxRoot = OPCPackage.open((InputStream)this.getInputStream(this.aasxPath));
        this.bundleFactory = new XMLAASBundleFactory(this.getXMLResourceString(aasxRoot));
        this.bundles = this.bundleFactory.create();
        return this.bundles;
    }

    private String getXMLResourceString(OPCPackage aasxPackage) throws InvalidFormatException, IOException {
        PackagePart originPart = aasxPackage.getPart(PackagingURIHelper.createPartName((String)AASX_ORIGIN));
        PackageRelationshipCollection originRelationships = originPart.getRelationshipsByType(XML_TYPE);
        if (originRelationships.size() > 1) {
            throw new RuntimeException("More than one 'aasx-spec' document found in .aasx");
        }
        if (originRelationships.size() == 0) {
            throw new RuntimeException("No 'aasx-spec' document found in .aasx");
        }
        PackagePart xmlPart = originPart.getRelatedPart(originRelationships.getRelationship(0));
        InputStream stream = xmlPart.getInputStream();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        return writer.toString();
    }

    private List<String> parseReferencedFilePathsFromAASX() throws IOException, ParserConfigurationException, SAXException, InvalidFormatException {
        Set<AASBundle> bundles = this.retrieveAASBundles();
        ArrayList submodels = new ArrayList();
        for (AASBundle bundle : bundles) {
            submodels.addAll(bundle.getSubmodels());
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (ISubmodel sm : submodels) {
            paths.addAll(this.parseElements(sm.getSubmodelElements().values()));
        }
        return paths;
    }

    private List<String> parseElements(Collection<ISubmodelElement> elements) {
        ArrayList<String> paths = new ArrayList<String>();
        for (ISubmodelElement element : elements) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                if (file.getValue().contains("://")) continue;
                paths.add(file.getValue());
                continue;
            }
            if (!(element instanceof ISubmodelElementCollection)) continue;
            ISubmodelElementCollection collection = (ISubmodelElementCollection)element;
            paths.addAll(this.parseElements(collection.getSubmodelElements().values()));
        }
        return paths;
    }

    public void unzipRelatedFiles() throws IOException, ParserConfigurationException, SAXException, URISyntaxException, InvalidFormatException {
        List<String> files = this.parseReferencedFilePathsFromAASX();
        OPCPackage aasxRoot = OPCPackage.open((InputStream)this.getInputStream(this.aasxPath));
        for (String filePath : files) {
            this.unzipFile(filePath, aasxRoot);
        }
    }

    private Path getRootFolder() throws IOException, URISyntaxException {
        URI uri = AASXPackageManager.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        URI parent = new File(uri).getParentFile().toURI();
        return Paths.get(parent);
    }

    private void unzipFile(String filePath, OPCPackage aasxRoot) throws IOException, URISyntaxException, InvalidFormatException {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        if (filePath.isEmpty()) {
            logger.warn("A file with empty path can not be unzipped.");
            return;
        }
        logger.info("Unzipping " + filePath + " to root folder:");
        String relativePath = "files/" + VABPathTools.getParentPath((String)filePath);
        Path rootPath = this.getRootFolder();
        Path destDir = rootPath.resolve(relativePath);
        logger.info("Unzipping to " + destDir);
        Files.createDirectories(destDir, new FileAttribute[0]);
        PackagePart part = aasxRoot.getPart(PackagingURIHelper.createPartName((String)("/" + filePath)));
        if (part == null) {
            logger.warn("File '" + filePath + "' could not be unzipped. It does not exist in .aasx.");
            return;
        }
        String targetPath = destDir.toString() + "/" + VABPathTools.getLastElement((String)filePath);
        InputStream stream = part.getInputStream();
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)new File(targetPath));
    }

    private InputStream getInputStream(String aasxFilePath) throws IOException {
        InputStream stream = BaSyxConfiguration.getResourceStream((String)aasxFilePath);
        if (stream != null) {
            return stream;
        }
        try {
            return new FileInputStream(aasxFilePath);
        }
        catch (FileNotFoundException e) {
            logger.error("File '" + aasxFilePath + "' to be loaded was not found.");
            throw e;
        }
    }
}

