/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.aggregator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.MultiSubmodelProvider;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.aas.restapi.vab.VABAASAPIFactory;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.submodel.restapi.vab.VABSubmodelAPIFactory;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;

public class AASAggregator
implements IAASAggregator {
    protected Map<String, MultiSubmodelProvider> aasProviderMap = new HashMap<String, MultiSubmodelProvider>();
    protected IAASRegistry registry;
    protected IAASAPIFactory aasApiProvider;
    protected ISubmodelAPIFactory smApiProvider;

    public AASAggregator() {
        this.aasApiProvider = new VABAASAPIFactory();
        this.smApiProvider = new VABSubmodelAPIFactory();
    }

    public AASAggregator(IAASAPIFactory aasApiProvider, ISubmodelAPIFactory smApiProvider) {
        this.aasApiProvider = aasApiProvider;
        this.smApiProvider = smApiProvider;
    }

    public AASAggregator(IAASRegistry registry) {
        this.registry = registry;
        this.aasApiProvider = new VABAASAPIFactory();
        this.smApiProvider = new VABSubmodelAPIFactory();
    }

    public AASAggregator(IAASAPIFactory aasApiProvider, ISubmodelAPIFactory smApiProvider, IAASRegistry registry) {
        this.registry = registry;
        this.aasApiProvider = aasApiProvider;
        this.smApiProvider = smApiProvider;
    }

    @Override
    public Collection<IAssetAdministrationShell> getAASList() {
        return this.aasProviderMap.values().stream().map(p -> {
            try {
                return p.getValue("/aas");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new RuntimeException();
            }
        }).map(m -> {
            AssetAdministrationShell aas = new AssetAdministrationShell();
            aas.putAll((Map)m);
            return aas;
        }).collect(Collectors.toList());
    }

    @Override
    public IAssetAdministrationShell getAAS(IIdentifier aasId) {
        IModelProvider aasProvider = this.getAASProvider(aasId);
        Map aasMap = (Map)aasProvider.getValue("/aas");
        AssetAdministrationShell aas = AssetAdministrationShell.createAsFacade(aasMap);
        return aas;
    }

    @Override
    public void createAAS(AssetAdministrationShell aas) {
        this.aasProviderMap.put(aas.getIdentification().getId(), this.createMultiSubmodelProvider(aas));
    }

    @Override
    public void updateAAS(AssetAdministrationShell aas) {
        this.aasProviderMap.put(aas.getIdentification().getId(), this.createMultiSubmodelProvider(aas));
    }

    private MultiSubmodelProvider createMultiSubmodelProvider(AssetAdministrationShell aas) {
        HTTPConnectorFactory connProvider = new HTTPConnectorFactory();
        IAASAPI aasApi = this.aasApiProvider.getAASApi(aas);
        AASModelProvider contentProvider = new AASModelProvider(aasApi);
        MultiSubmodelProvider multiAASProvider = new MultiSubmodelProvider(contentProvider, this.registry, connProvider, this.smApiProvider, this.aasApiProvider);
        return multiAASProvider;
    }

    @Override
    public void deleteAAS(IIdentifier aasId) {
        this.aasProviderMap.remove(aasId.getId());
    }

    @Override
    public IModelProvider getAASProvider(IIdentifier aasId) {
        MultiSubmodelProvider provider = this.aasProviderMap.get(aasId.getId());
        if (provider == null) {
            throw new ResourceNotFoundException("AAS with Id " + aasId.getId() + " does not exist");
        }
        return provider;
    }
}

