/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.json;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.parts.ConceptDescription;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;

public class JSONToMetamodelConverter {
    private Map<String, Object> root;
    private List<Asset> assetBuf;

    public JSONToMetamodelConverter(String jsonContent) {
        this.root = (Map)new GSONTools(new DefaultTypeFactory()).deserialize(jsonContent);
    }

    public List<AssetAdministrationShell> parseAAS() {
        this.assetBuf = this.parseAssets();
        return ((List)this.root.get("assetAdministrationShells")).stream().map(this::parseAssetAdministrationShell).collect(Collectors.toList());
    }

    private AssetAdministrationShell parseAssetAdministrationShell(Object mapObject) {
        Map aasMap = (Map)mapObject;
        Map assetRefMap = (Map)aasMap.get("asset");
        if (assetRefMap.get("keys") == null && assetRefMap.get("kind") != null) {
            return AssetAdministrationShell.createAsFacade((Map)mapObject);
        }
        aasMap.put("assetRef", assetRefMap);
        Reference assetRef = Reference.createAsFacade((Map)aasMap.get("assetRef"));
        IKey lastKey = assetRef.getKeys().get(assetRef.getKeys().size() - 1);
        String idValue = lastKey.getValue();
        for (Asset asset : this.assetBuf) {
            if (!asset.getIdentification().getId().equals(idValue)) continue;
            aasMap.put("asset", asset);
            break;
        }
        return AssetAdministrationShell.createAsFacade((Map)mapObject);
    }

    public List<Submodel> parseSubmodels() {
        return ((List)this.root.get("submodels")).stream().map(i -> Submodel.createAsFacade((Map)i)).collect(Collectors.toList());
    }

    public List<Asset> parseAssets() {
        return ((List)this.root.get("assets")).stream().map(i -> Asset.createAsFacade((Map)i)).collect(Collectors.toList());
    }

    public List<ConceptDescription> parseConceptDescriptions() {
        return ((List)this.root.get("conceptDescriptions")).stream().map(i -> ConceptDescription.createAsFacade((Map)i)).collect(Collectors.toList());
    }
}

