/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.manager;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.aas.aggregator.proxy.AASAggregatorProxy;
import org.eclipse.basyx.aas.manager.api.IAssetAdministrationShellManager;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.connected.ConnectedAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.connected.ConnectedSubmodel;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.vab.exception.FeatureNotImplementedException;
import org.eclipse.basyx.vab.factory.java.ModelProxyFactory;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;

public class ConnectedAssetAdministrationShellManager
implements IAssetAdministrationShellManager {
    protected IAASRegistry aasDirectory;
    protected IConnectorFactory connectorFactory;
    protected ModelProxyFactory proxyFactory;

    public ConnectedAssetAdministrationShellManager(IAASRegistry directory) {
        this(directory, new HTTPConnectorFactory());
    }

    public ConnectedAssetAdministrationShellManager(IAASRegistry directory, IConnectorFactory provider) {
        this.aasDirectory = directory;
        this.connectorFactory = provider;
        this.proxyFactory = new ModelProxyFactory(provider);
    }

    @Override
    public ISubmodel retrieveSubmodel(IIdentifier aasId, IIdentifier smId) {
        SubmodelDescriptor smDescriptor = this.aasDirectory.lookupSubmodel(aasId, smId);
        String addr = smDescriptor.getFirstEndpoint();
        return new ConnectedSubmodel(this.proxyFactory.createProxy(addr));
    }

    @Override
    public ConnectedAssetAdministrationShell retrieveAAS(IIdentifier aasId) {
        VABElementProxy proxy = this.getAASProxyFromId(aasId);
        return new ConnectedAssetAdministrationShell(proxy);
    }

    @Override
    public Map<String, ISubmodel> retrieveSubmodels(IIdentifier aasId) {
        AASDescriptor aasDesc = this.aasDirectory.lookupAAS(aasId);
        Collection<SubmodelDescriptor> smDescriptors = aasDesc.getSubmodelDescriptors();
        HashMap<String, ISubmodel> submodels = new HashMap<String, ISubmodel>();
        for (SubmodelDescriptor smDesc : smDescriptors) {
            String smEndpoint = smDesc.getFirstEndpoint();
            String smIdShort = smDesc.getIdShort();
            VABElementProxy smProxy = this.proxyFactory.createProxy(smEndpoint);
            ConnectedSubmodel connectedSM = new ConnectedSubmodel(smProxy);
            submodels.put(smIdShort, connectedSM);
        }
        return submodels;
    }

    private VABElementProxy getAASProxyFromId(IIdentifier aasId) {
        AASDescriptor aasDescriptor = this.aasDirectory.lookupAAS(aasId);
        String addr = aasDescriptor.getFirstEndpoint();
        return this.proxyFactory.createProxy(addr);
    }

    @Override
    public Collection<IAssetAdministrationShell> retrieveAASAll() {
        throw new FeatureNotImplementedException();
    }

    @Override
    public void deleteAAS(IIdentifier id) {
        AASDescriptor aasDescriptor = this.aasDirectory.lookupAAS(id);
        String addr = aasDescriptor.getFirstEndpoint();
        addr = VABPathTools.stripSlashes(addr);
        addr = addr.substring(0, addr.length() - "/aas".length());
        this.proxyFactory.createProxy(addr).deleteValue("");
        this.aasDirectory.delete(id);
    }

    @Override
    public void createSubmodel(IIdentifier aasId, Submodel submodel) {
        this.retrieveAAS(aasId).addSubmodel(submodel);
        AASDescriptor aasDescriptor = this.aasDirectory.lookupAAS(aasId);
        String addr = aasDescriptor.getFirstEndpoint();
        String smEndpoint = VABPathTools.concatenatePaths(addr, "submodels", submodel.getIdShort(), "submodel");
        this.aasDirectory.register(aasId, new SubmodelDescriptor(submodel, smEndpoint));
    }

    @Override
    public void deleteSubmodel(IIdentifier aasId, IIdentifier submodelId) {
        ConnectedAssetAdministrationShell shell = this.retrieveAAS(aasId);
        shell.removeSubmodel(submodelId);
        this.aasDirectory.delete(aasId, submodelId);
    }

    @Override
    public void createAAS(AssetAdministrationShell aas, String endpoint) {
        if (!(endpoint = VABPathTools.stripSlashes(endpoint)).endsWith("shells")) {
            endpoint = endpoint + "/shells";
        }
        IModelProvider provider = this.connectorFactory.getConnector(endpoint);
        AASAggregatorProxy proxy = new AASAggregatorProxy(provider);
        proxy.createAAS(aas);
        try {
            String combinedEndpoint = VABPathTools.concatenatePaths(endpoint, URLEncoder.encode(aas.getIdentification().getId(), "UTF-8"), "aas");
            this.aasDirectory.register(new AASDescriptor(aas, combinedEndpoint));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding failed. This should never happen");
        }
    }
}

