/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.restapi;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.aas.restapi.vab.VABAASAPI;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.NotAnInvokableException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.lambda.VABLambdaProvider;

public class AASModelProvider
implements IModelProvider {
    private IAASAPI aasApi;

    public AASModelProvider(IModelProvider modelProvider) {
        this.aasApi = new VABAASAPI(modelProvider);
    }

    public AASModelProvider(AssetAdministrationShell shell) {
        this.aasApi = new VABAASAPI(new VABLambdaProvider(shell));
    }

    public AASModelProvider(IAASAPI aasApi) {
        this.aasApi = aasApi;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        if ((path = this.preparePath(path)).isEmpty()) {
            return this.aasApi.getAAS();
        }
        throw new MalformedRequestException("Path " + path + " is not supported");
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        throw new MalformedRequestException("For an AAS, Set is not supported");
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        if (!(path = this.preparePath(path)).equals("submodels")) {
            throw new MalformedRequestException("Path " + path + " is not supported");
        }
        Map smMap = (Map)newEntity;
        Submodel sm = Submodel.createAsFacade(smMap);
        this.aasApi.removeSubmodel(sm.getIdentification().getId());
        this.aasApi.addSubmodel(sm.getReference());
    }

    private String preparePath(String path) {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        return path;
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        String[] splitted = VABPathTools.splitPath(path = this.preparePath(path));
        if (splitted.length != 3 || !splitted[1].equals("submodels")) {
            throw new MalformedRequestException("Delete on path " + path + " is not supported");
        }
        String id = splitted[2];
        this.aasApi.removeSubmodel(id);
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete with parameter is not supported");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        throw new NotAnInvokableException("An AAS does not contain any operations that can be invoked");
    }
}

