/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.restapi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.aas.restapi.vab.VABAASAPIFactory;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.SubmodelProvider;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.submodel.restapi.vab.VABSubmodelAPIFactory;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;

public class MultiSubmodelProvider
implements IModelProvider {
    public static final String AAS = "aas";
    public static final String SUBMODELS_PREFIX = VABPathTools.concatenatePaths("aas", "submodels");
    protected AASModelProvider aas_provider = null;
    protected IIdentifier aasId = null;
    protected Map<String, SubmodelProvider> submodel_providers = new HashMap<String, SubmodelProvider>();
    protected IAASRegistry registry = null;
    protected IConnectorFactory connectorFactory = null;
    protected IAASAPIFactory aasApiProvider;
    protected ISubmodelAPIFactory smApiProvider;

    public MultiSubmodelProvider() {
        this.aasApiProvider = new VABAASAPIFactory();
        this.smApiProvider = new VABSubmodelAPIFactory();
        IAASAPI aasApi = this.aasApiProvider.getAASApi(new AssetAdministrationShell());
        this.setAssetAdministrationShell(new AASModelProvider(aasApi));
    }

    public MultiSubmodelProvider(AASModelProvider contentProvider, IAASAPIFactory aasApiProvider, ISubmodelAPIFactory smApiProvider) {
        this.aasApiProvider = aasApiProvider;
        this.smApiProvider = smApiProvider;
        this.setAssetAdministrationShell(contentProvider);
    }

    public MultiSubmodelProvider(AASModelProvider contentProvider) {
        this.aasApiProvider = new VABAASAPIFactory();
        this.smApiProvider = new VABSubmodelAPIFactory();
        this.setAssetAdministrationShell(contentProvider);
    }

    public MultiSubmodelProvider(SubmodelProvider contentProvider) {
        this();
        this.addSubmodel(contentProvider);
    }

    public MultiSubmodelProvider(IAASRegistry registry, IConnectorFactory provider) {
        this();
        this.registry = registry;
        this.connectorFactory = provider;
    }

    public MultiSubmodelProvider(AASModelProvider contentProvider, IAASRegistry registry, IConnectorFactory connectorFactory, ISubmodelAPIFactory smApiProvider, IAASAPIFactory aasApiProvider) {
        this(contentProvider, aasApiProvider, smApiProvider);
        this.registry = registry;
        this.connectorFactory = connectorFactory;
    }

    public MultiSubmodelProvider(AASModelProvider contentProvider, IAASRegistry registry, HTTPConnectorFactory provider) {
        this(contentProvider);
        this.registry = registry;
        this.connectorFactory = provider;
    }

    public void setAssetAdministrationShell(AASModelProvider modelContentProvider) {
        this.aas_provider = modelContentProvider;
        this.aasId = AssetAdministrationShell.createAsFacade((Map)modelContentProvider.getValue("")).getIdentification();
    }

    public void addSubmodel(SubmodelProvider modelContentProvider) {
        Submodel sm = Submodel.createAsFacade((Map)modelContentProvider.getValue("/submodel"));
        this.addSubmodel(sm, modelContentProvider);
    }

    private void createSubmodel(Object newSM) throws ProviderException {
        Submodel sm = Submodel.createAsFacade((Map)newSM);
        ISubmodelAPI smApi = this.smApiProvider.getSubmodelAPI(sm);
        this.addSubmodel(sm, new SubmodelProvider(smApi));
    }

    private void addSubmodel(Submodel sm, SubmodelProvider modelContentProvider) {
        String smIdShort = sm.getIdShort();
        this.submodel_providers.put(smIdShort, modelContentProvider);
        this.aas_provider.createValue("/submodels", sm);
    }

    public void removeProvider(String elementId) {
        this.submodel_providers.remove(elementId);
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        String[] pathElements = VABPathTools.splitPath(path);
        if (pathElements.length > 0 && pathElements[0].equals(AAS)) {
            if (pathElements.length == 1) {
                return this.aas_provider.getValue("");
            }
            if (pathElements[1].equals("submodels")) {
                if (pathElements.length == 2) {
                    return this.retrieveSubmodels();
                }
                IModelProvider provider = this.submodel_providers.get(pathElements[2]);
                if (provider == null) {
                    provider = this.getModelProvider(pathElements[2]);
                }
                return provider.getValue(VABPathTools.buildPath(pathElements, 3));
            }
            return this.aas_provider.getValue(VABPathTools.buildPath(pathElements, 1));
        }
        throw new MalformedRequestException("The request " + path + " is not allowed for this endpoint");
    }

    private Object retrieveSubmodels() throws ProviderException {
        HashSet<Submodel> submodels = new HashSet<Submodel>();
        for (IModelProvider iModelProvider : this.submodel_providers.values()) {
            submodels.add(Submodel.createAsFacade((Map)iModelProvider.getValue("/submodel")));
        }
        if (this.registry != null) {
            AASDescriptor desc = this.registry.lookupAAS(this.aasId);
            String string = desc.getFirstEndpoint();
            String aasServerURL = MultiSubmodelProvider.getServerURL(string);
            List localIds = submodels.stream().map(sm -> sm.getIdentification().getId()).collect(Collectors.toList());
            List missingIds = desc.getSubmodelDescriptors().stream().map(d -> d.getIdentifier()).filter(id -> !localIds.contains(id.getId())).collect(Collectors.toList());
            if (!missingIds.isEmpty()) {
                List missingEndpoints = missingIds.stream().map(id -> desc.getSubmodelDescriptorFromIdentifierId(id.getId())).map(smDesc -> smDesc.getFirstEndpoint()).collect(Collectors.toList());
                for (String missingEndpoint : missingEndpoints) {
                    if (!MultiSubmodelProvider.getServerURL(missingEndpoint).equals(aasServerURL)) continue;
                    throw new ResourceNotFoundException("The Submodel at Endpoint '" + missingEndpoint + "' does not exist on this server. It seems to be registered but not actually present.");
                }
                List remoteSms = missingEndpoints.stream().map(endpoint -> this.connectorFactory.getConnector((String)endpoint)).map(p -> (Map)p.getValue("")).map(m -> Submodel.createAsFacade(m)).collect(Collectors.toList());
                submodels.addAll(remoteSms);
            }
        }
        return submodels;
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        String[] pathElements = VABPathTools.splitPath(path);
        String propertyPath = VABPathTools.buildPath(pathElements, 3);
        if (path.equals(AAS)) {
            this.createAssetAdministrationShell(newValue);
        } else {
            if (!path.startsWith(SUBMODELS_PREFIX)) {
                throw new MalformedRequestException("Access to MultiSubmodelProvider always has to start with \"" + SUBMODELS_PREFIX + "\", was " + path);
            }
            if (propertyPath.isEmpty()) {
                this.createSubmodel(newValue);
            } else {
                IModelProvider provider = this.isSubmodelLocal(pathElements[2]) ? (IModelProvider)this.submodel_providers.get(pathElements[2]) : this.getModelProvider(pathElements[2]);
                provider.setValue(propertyPath, newValue);
            }
        }
    }

    @Override
    public void createValue(String path, Object newValue) throws ProviderException {
        throw new MalformedRequestException("Create is not supported by VABMultiSubmodelProvider. Path was: " + path);
    }

    private void createAssetAdministrationShell(Object newAAS) {
        Map aas = (Map)newAAS;
        AssetAdministrationShell shell = AssetAdministrationShell.createAsFacade(aas);
        IAASAPI aasApi = this.aasApiProvider.getAASApi(shell);
        this.aas_provider = new AASModelProvider(aasApi);
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        if (!path.startsWith(SUBMODELS_PREFIX)) {
            throw new MalformedRequestException("Access to MultiSubmodelProvider always has to start with \"" + SUBMODELS_PREFIX + "\", was " + path);
        }
        String[] pathElements = VABPathTools.splitPath(path);
        String propertyPath = VABPathTools.buildPath(pathElements, 3);
        if (pathElements.length == 3) {
            String smIdShort = pathElements[2];
            if (!this.isSubmodelLocal(smIdShort)) {
                return;
            }
            Submodel sm = Submodel.createAsFacade((Map)this.submodel_providers.get(smIdShort).getValue("/submodel"));
            this.aas_provider.deleteValue(SUBMODELS_PREFIX + "/" + sm.getIdentification().getId());
            this.submodel_providers.remove(smIdShort);
        } else if (propertyPath.length() > 0) {
            IModelProvider provider = this.isSubmodelLocal(pathElements[2]) ? (IModelProvider)this.submodel_providers.get(pathElements[2]) : this.getModelProvider(pathElements[2]);
            provider.deleteValue(propertyPath);
        }
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("DeleteValue with a parameter is not supported. Path was: " + path);
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        if (!path.startsWith(SUBMODELS_PREFIX)) {
            throw new MalformedRequestException("Access to MultiSubmodelProvider always has to start with \"" + SUBMODELS_PREFIX + "\", was " + path);
        }
        String[] pathElements = VABPathTools.splitPath(path);
        String operationPath = VABPathTools.buildPath(pathElements, 3);
        IModelProvider provider = this.isSubmodelLocal(pathElements[2]) ? (IModelProvider)this.submodel_providers.get(pathElements[2]) : this.getModelProvider(pathElements[2]);
        return provider.invokeOperation(operationPath, parameter);
    }

    private boolean isSubmodelLocal(String submodelId) {
        return this.submodel_providers.containsKey(submodelId);
    }

    private boolean doesRegistryExist() {
        return this.registry != null;
    }

    private SubmodelDescriptor getSubmodelDescriptorFromRegistry(String submodelIdShort) {
        AASDescriptor aasDescriptor = this.registry.lookupAAS(this.aasId);
        SubmodelDescriptor desc = aasDescriptor.getSubmodelDescriptorFromIdShort(submodelIdShort);
        if (desc == null) {
            throw new ResourceNotFoundException("Could not resolve Submodel with idShort " + submodelIdShort + " for AAS " + this.aasId);
        }
        return desc;
    }

    private IModelProvider getModelProvider(SubmodelDescriptor submodelDescriptor) {
        String endpoint = submodelDescriptor.getFirstEndpoint();
        endpoint = endpoint.substring(0, endpoint.length() - "submodel".length() - 1);
        return this.connectorFactory.getConnector(endpoint);
    }

    private IModelProvider getModelProvider(String submodelId) {
        if (!this.doesRegistryExist()) {
            throw new ResourceNotFoundException("Submodel with id " + submodelId + " cannot be resolved locally, but no registry is passed");
        }
        SubmodelDescriptor submodelDescriptor = this.getSubmodelDescriptorFromRegistry(submodelId);
        return this.getModelProvider(submodelDescriptor);
    }

    public static String getServerURL(String endpoint) {
        int endServerURL = endpoint.indexOf("/aas");
        if (endServerURL < 0) {
            return endpoint;
        }
        return endpoint.substring(0, endServerURL);
    }
}

