/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.restapi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.registration.restapi.AASRegistryModelProvider;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.map.MapTaggedDirectory;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;

public class TaggedDirectoryProvider
extends AASRegistryModelProvider {
    private MapTaggedDirectory directory;
    public static final String PREFIX = "api/v1/directory";
    public static final String API_ACCESS = "?tags=";

    public TaggedDirectoryProvider() {
        this(new MapTaggedDirectory(new HashMap<String, AASDescriptor>(), new HashMap<String, Set<TaggedAASDescriptor>>()));
    }

    public TaggedDirectoryProvider(MapTaggedDirectory directory) {
        super(directory);
        this.directory = directory;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        if ((path = VABPathTools.stripSlashes(path)).startsWith(PREFIX)) {
            return this.directory.lookupTags(this.extractTags(path));
        }
        return super.getValue(path);
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        if ((path = VABPathTools.stripSlashes(path)).startsWith(PREFIX)) {
            this.directory.register(TaggedAASDescriptor.createAsFacade((Map)newEntity));
        } else {
            super.createValue(path, newEntity);
        }
    }

    private Set<String> extractTags(String path) {
        path = VABPathTools.stripSlashes(path);
        path = path.replaceFirst(PREFIX, "");
        path = path.replaceFirst(Pattern.quote(API_ACCESS), "");
        return Arrays.stream(path.split(",")).collect(Collectors.toSet());
    }
}

