/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.SubmodelElementXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OperationXMLConverter
extends SubmodelElementXMLConverter {
    public static final String OPERATION = "aas:operation";
    public static final String INPUT_VARIABLE = "aas:inputVariable";
    public static final String OUTPUT_VARIABLE = "aas:outputVariable";
    public static final String INOUTPUT_VARIABLE = "aas:inoutputVariable";
    public static final String OPERATION_VARIABLE = "aas:operationVariable";

    public static Operation parseOperation(Map<String, Object> xmlObject) {
        Map inoutObj;
        Map outObj;
        ArrayList<OperationVariable> inList = new ArrayList();
        ArrayList<OperationVariable> outList = new ArrayList();
        ArrayList<OperationVariable> inoutList = new ArrayList();
        Map inObj = (Map)xmlObject.get(INPUT_VARIABLE);
        if (inObj != null) {
            inList = OperationXMLConverter.getOperationVariables(inObj);
        }
        if ((outObj = (Map)xmlObject.get(OUTPUT_VARIABLE)) != null) {
            outList = OperationXMLConverter.getOperationVariables(outObj);
        }
        if ((inoutObj = (Map)xmlObject.get(INOUTPUT_VARIABLE)) != null) {
            inoutList = OperationXMLConverter.getOperationVariables(inoutObj);
        }
        Operation operation = new Operation(inList, outList, inoutList, null);
        OperationXMLConverter.populateSubmodelElement(xmlObject, operation);
        return operation;
    }

    private static OperationVariable parseOperationVariable(Map<String, Object> xmlObject) {
        SubmodelElement submodelElement = OperationXMLConverter.getSubmodelElement((Map)xmlObject.get("aas:value"));
        OperationVariable operationVariable = new OperationVariable(submodelElement);
        return operationVariable;
    }

    public static Element buildOperation(Document document, IOperation operation) {
        Collection<IOperationVariable> out;
        Collection<IOperationVariable> in;
        Element operationRoot = document.createElement(OPERATION);
        OperationXMLConverter.populateSubmodelElement(document, operationRoot, operation);
        Collection<IOperationVariable> inout = operation.getInOutputVariables();
        if (inout != null) {
            Element valueRoot = document.createElement(INOUTPUT_VARIABLE);
            operationRoot.appendChild(valueRoot);
            for (IOperationVariable iOperationVariable : inout) {
                valueRoot.appendChild(OperationXMLConverter.buildOperationVariable(document, iOperationVariable));
            }
        }
        if ((in = operation.getInputVariables()) != null) {
            Element valueRoot = document.createElement(INPUT_VARIABLE);
            operationRoot.appendChild(valueRoot);
            for (IOperationVariable operationVariable : in) {
                valueRoot.appendChild(OperationXMLConverter.buildOperationVariable(document, operationVariable));
            }
        }
        if ((out = operation.getOutputVariables()) != null) {
            Element element = document.createElement(OUTPUT_VARIABLE);
            operationRoot.appendChild(element);
            for (IOperationVariable operationVariable : out) {
                element.appendChild(OperationXMLConverter.buildOperationVariable(document, operationVariable));
            }
        }
        return operationRoot;
    }

    private static Element buildOperationVariable(Document document, IOperationVariable operationVariable) {
        Element operationVariableRoot = document.createElement(OPERATION_VARIABLE);
        ISubmodelElement value = operationVariable.getValue();
        if (value != null) {
            Element valueRoot = document.createElement("aas:value");
            valueRoot.appendChild(OperationXMLConverter.buildSubmodelElement(document, value));
            operationVariableRoot.appendChild(valueRoot);
        }
        return operationVariableRoot;
    }

    private static List<OperationVariable> getOperationVariables(Map<String, Object> varObj) {
        ArrayList<OperationVariable> variableList = new ArrayList<OperationVariable>();
        Map<String, Object> operationVarObj = varObj.get(OPERATION_VARIABLE);
        if (operationVarObj == null && varObj.get("aas:value") != null) {
            operationVarObj = varObj;
        }
        List<Map<String, Object>> xmlOpVars = XMLHelper.getList(operationVarObj);
        for (Map<String, Object> map : xmlOpVars) {
            variableList.add(OperationXMLConverter.parseOperationVariable(map));
        }
        return variableList;
    }
}

