/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement;

import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IRange;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement.ConnectedDataElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueTypeHelper;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.range.Range;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.range.RangeValue;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;

public class ConnectedRange
extends ConnectedDataElement
implements IRange {
    public ConnectedRange(VABElementProxy proxy) {
        super(proxy);
    }

    @Override
    public ValueType getValueType() {
        return ValueTypeHelper.readTypeDef(this.getElem().getPath("valueType"));
    }

    @Override
    public Object getMin() {
        Object min = this.getElem().getPath("min");
        return ValueTypeHelper.getJavaObject(min, this.getValueType());
    }

    @Override
    public Object getMax() {
        Object max = this.getElem().getPath("max");
        return ValueTypeHelper.getJavaObject(max, this.getValueType());
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.RANGE;
    }

    @Override
    public RangeValue getValue() {
        return new RangeValue(this.getMin(), this.getMax());
    }

    @Override
    public void setValue(Object value) {
        if (!RangeValue.isRangeValue(value)) {
            throw new IllegalArgumentException("Given object " + value + " is not a RangeValue");
        }
        RangeValue rangeValue = RangeValue.createAsFacade((Map)value);
        this.setValue(rangeValue);
    }

    @Override
    public Range getLocalCopy() {
        return Range.createAsFacade(this.getElem()).getLocalCopy();
    }

    @Override
    public void setValue(RangeValue rangeValue) {
        Object minRaw = rangeValue.getMin();
        Object maxRaw = rangeValue.getMax();
        RangeValue prepared = new RangeValue(ValueTypeHelper.prepareForSerialization(minRaw), ValueTypeHelper.prepareForSerialization(maxRaw));
        this.getProxy().setValue("value", prepared);
    }
}

