/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.connected.submodelelement.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.ConnectedSubmodelElement;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.operation.ConnectedAsyncInvocation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.eclipse.basyx.submodel.restapi.operation.InvocationRequest;
import org.eclipse.basyx.submodel.restapi.operation.InvocationResponse;
import org.eclipse.basyx.vab.exception.provider.WrongNumberOfParametersException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;

public class ConnectedOperation
extends ConnectedSubmodelElement
implements IOperation {
    public static final int DEFAULT_ASYNC_TIMEOUT = 10000;

    public ConnectedOperation(VABElementProxy proxy) {
        super(proxy);
    }

    @Override
    public Collection<IOperationVariable> getInputVariables() {
        return Operation.createAsFacade(this.getElem()).getInputVariables();
    }

    @Override
    public Collection<IOperationVariable> getOutputVariables() {
        return Operation.createAsFacade(this.getElem()).getOutputVariables();
    }

    @Override
    public Collection<IOperationVariable> getInOutputVariables() {
        return Operation.createAsFacade(this.getElem()).getInOutputVariables();
    }

    @Override
    public Object invoke(Object ... params) {
        SubmodelElement[] wrapper = this.createElementWrapper(params);
        SubmodelElement[] result = this.invoke(wrapper);
        return this.unwrapResult(result);
    }

    @Override
    public SubmodelElement[] invoke(SubmodelElement ... elems) {
        InvocationRequest request = this.createInvocationRequest(10000, elems);
        Object responseObj = this.getProxy().invokeOperation("invoke", request);
        InvocationResponse response = InvocationResponse.createAsFacade((Map)responseObj);
        Collection<IOperationVariable> outputArguments = response.getOutputArguments();
        List<SubmodelElement> elements = outputArguments.stream().map(IOperationVariable::getValue).collect(Collectors.toList());
        SubmodelElement[] result = new SubmodelElement[elements.size()];
        elements.toArray(result);
        return result;
    }

    private InvocationRequest createInvocationRequest(int timeout, SubmodelElement ... elems) {
        Collection inputArguments = Arrays.asList(elems).stream().map(OperationVariable::new).collect(Collectors.toList());
        String requestId = UUID.randomUUID().toString();
        return new InvocationRequest(requestId, new ArrayList<IOperationVariable>(), inputArguments, timeout);
    }

    private SubmodelElement[] createElementWrapper(Object ... params) {
        Collection<IOperationVariable> inputVariables = this.getInputVariables();
        if (inputVariables.size() != params.length) {
            throw new WrongNumberOfParametersException(this.getIdShort(), inputVariables, params);
        }
        SubmodelElement[] ret = new SubmodelElement[params.length];
        Iterator<IOperationVariable> iterator = inputVariables.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            IOperationVariable matchedInput = iterator.next();
            ISubmodelElement inputElement = matchedInput.getValue();
            SubmodelElement copy = inputElement.getLocalCopy();
            copy.setValue(params[i]);
            ret[i] = copy;
            ++i;
        }
        return ret;
    }

    @Override
    public ConnectedAsyncInvocation invokeAsync(Object ... params) {
        SubmodelElement[] smElements = this.createElementWrapper(params);
        InvocationRequest request = this.createInvocationRequest(10000, smElements);
        return new ConnectedAsyncInvocation(this.getProxy(), this.getIdShort(), request);
    }

    @Override
    public ConnectedAsyncInvocation invokeAsyncWithTimeout(int timeout, Object ... params) {
        SubmodelElement[] smElements = this.createElementWrapper(params);
        InvocationRequest request = this.createInvocationRequest(timeout, smElements);
        return new ConnectedAsyncInvocation(this.getProxy(), this.getIdShort(), request);
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.OPERATION;
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("An Operation has no value");
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("An Operation has no value");
    }

    private Object unwrapResult(Object result) {
        SubmodelElement[] arr;
        if (result instanceof Collection) {
            Map map;
            Collection coll = (Collection)result;
            if (coll.isEmpty()) {
                return result;
            }
            Object resultWrapper = coll.iterator().next();
            if (resultWrapper instanceof Map && (map = (Map)resultWrapper).get("idShort").equals("Response") && map.get("value") != null) {
                return map.get("value");
            }
        } else if (result instanceof SubmodelElement[] && (arr = (SubmodelElement[])result).length > 0 && arr[0] instanceof Map) {
            return arr[0].getValue();
        }
        return result;
    }

    @Override
    public Operation getLocalCopy() {
        return Operation.createAsFacade(this.getElem()).getLocalCopy();
    }
}

