/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.qualifier;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IEmbeddedDataSpecification;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IAdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.vab.model.VABModelMap;

public class AdministrativeInformation
extends VABModelMap<Object>
implements IAdministrativeInformation {
    public static final String VERSION = "version";
    public static final String REVISION = "revision";

    public AdministrativeInformation() {
        this.putAll(new HasDataSpecification());
    }

    public AdministrativeInformation(String version, String revision) {
        this.putAll(new HasDataSpecification());
        this.setVersionInformation(version, revision);
    }

    public static AdministrativeInformation createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        AdministrativeInformation ret = new AdministrativeInformation();
        ret.setMap(map);
        return ret;
    }

    @Override
    public Collection<IReference> getDataSpecificationReferences() {
        return HasDataSpecification.createAsFacade(this).getDataSpecificationReferences();
    }

    public void setDataSpecificationReferences(Collection<IReference> ref) {
        HasDataSpecification.createAsFacade(this).setDataSpecificationReferences(ref);
    }

    @Override
    public Collection<IEmbeddedDataSpecification> getEmbeddedDataSpecifications() {
        return HasDataSpecification.createAsFacade(this).getEmbeddedDataSpecifications();
    }

    public void setEmbeddedDataSpecifications(Collection<IEmbeddedDataSpecification> embeddedDataSpecifications) {
        HasDataSpecification.createAsFacade(this).setEmbeddedDataSpecifications(embeddedDataSpecifications);
    }

    public void setVersionInformation(String version, String revision) {
        this.setVersion(version);
        if (!Strings.isNullOrEmpty((String)revision) && Strings.isNullOrEmpty((String)version)) {
            throw new RuntimeException("revision cannot be set while version is not set");
        }
        this.setRevision(revision);
    }

    private void setVersion(String version) {
        this.put(VERSION, version);
    }

    @Override
    public String getVersion() {
        return (String)this.get(VERSION);
    }

    private void setRevision(String revision) {
        this.put(REVISION, revision);
    }

    @Override
    public String getRevision() {
        return (String)this.get(REVISION);
    }
}

