/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.poi.ss.formula.functions.T;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IAsyncInvocation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationExecutionErrorException;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationExecutionTimeoutException;

public class AsyncInvocation
implements IAsyncInvocation {
    private static ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(0);
    private String operationId;
    private CompletableFuture<Void> future;
    private Object result;
    private RuntimeException exception;

    public AsyncInvocation(Operation operation, int timeout, Object ... parameters) {
        this.operationId = operation.getIdShort();
        Function invokable = (Function)operation.get("invokable");
        this.future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> invokable.apply(parameters)).acceptEither(this.setTimeout(timeout), futureResult -> {
            this.result = futureResult;
        })).exceptionally(throwable -> {
            this.exception = throwable.getCause() instanceof OperationExecutionTimeoutException ? (RuntimeException)throwable.getCause() : new OperationExecutionErrorException("Exception while executing Operation Operation '" + this.operationId + "'", (Throwable)throwable);
            return null;
        });
    }

    private CompletableFuture<T> setTimeout(int timeout) {
        CompletableFuture<T> timeoutFuture = new CompletableFuture<T>();
        delayer.schedule(() -> timeoutFuture.completeExceptionally(new OperationExecutionTimeoutException("Operation " + this.operationId + " timed out")), (long)timeout, TimeUnit.MILLISECONDS);
        return timeoutFuture;
    }

    @Override
    public Object getResult() {
        try {
            this.future.get();
        }
        catch (Exception e) {
            throw new OperationExecutionErrorException("Exception while executing Operation Operation '" + this.operationId + "'", e.getCause());
        }
        if (this.exception instanceof OperationExecutionTimeoutException || this.exception instanceof OperationExecutionErrorException) {
            throw this.exception;
        }
        return this.result;
    }

    @Override
    public boolean isFinished() {
        return this.future.isDone();
    }

    public String getOperationId() {
        return this.operationId;
    }
}

