/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.address;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.types.digitalnameplate.enums.PhoneType;

public class Phone
extends SubmodelElementCollection {
    public static final String TELEPHONENUMBERID = "TelephoneNumber";
    public static final String TYPEOFTELEPHONEID = "TypeOfTelephone";
    public static final String PHONEID = "Phone";
    public static final Reference SEMANTICID = new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAQ833#005", KeyType.IRDI));

    private Phone() {
    }

    public Phone(String idShort, LangString telephoneNumber) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setTelephoneNumber(telephoneNumber);
    }

    public Phone(String idShort, MultiLanguageProperty telephoneNumber) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setTelephoneNumber(telephoneNumber);
    }

    public static Phone createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Phone.isValid(obj)) {
            throw new MetamodelConstructionException(Phone.class, obj);
        }
        Phone phone = new Phone();
        phone.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return phone;
    }

    private static Phone createAsFacadeNonStrict(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        Phone phone = new Phone();
        phone.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return phone;
    }

    public static boolean isValid(Map<String, Object> obj) {
        Phone phone = Phone.createAsFacadeNonStrict(obj);
        return SubmodelElementCollection.isValid(obj) && MultiLanguageProperty.isValid((Map)((Object)phone.getTelephoneNumber()));
    }

    public void setTelephoneNumber(MultiLanguageProperty telephoneNumber) {
        this.addSubmodelElement(telephoneNumber);
    }

    public void setTelephoneNumber(LangString telephoneNumber) {
        MultiLanguageProperty phoneProp = new MultiLanguageProperty(TELEPHONENUMBERID);
        phoneProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO136#002", IdentifierType.IRDI)));
        phoneProp.setValue(new LangStrings(telephoneNumber));
        this.setTelephoneNumber(phoneProp);
    }

    public void setTypeOfTelephone(Property type) {
        this.addSubmodelElement(type);
    }

    public void setTypeOfTelephone(PhoneType type) {
        Property phoneTypeProp = new Property(TYPEOFTELEPHONEID, ValueType.String);
        phoneTypeProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO137#003", IdentifierType.IRDI)));
        phoneTypeProp.setValue(type.toString());
        this.setTypeOfTelephone(phoneTypeProp);
    }

    public IProperty getTypeOfTelephone() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(TYPEOFTELEPHONEID)));
    }

    public IMultiLanguageProperty getTelephoneNumber() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(TELEPHONENUMBERID)));
    }
}

