/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.factory.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParser {
    private static final String TEXT = "#text";

    public static Map<String, Object> buildXmlMap(String xmlContent) throws ParserConfigurationException, SAXException, IOException {
        Map<String, Object> retMap = new HashMap<String, Object>();
        xmlContent = xmlContent.replaceAll(">\\s*<", "><");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setIgnoringElementContentWhitespace(true);
        dbFactory.setIgnoringComments(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        InputSource iSrc = new InputSource(new StringReader(xmlContent));
        Document doc = dBuilder.parse(iSrc);
        doc.getDocumentElement().normalize();
        Element rootNode = doc.getDocumentElement();
        retMap.put(rootNode.getNodeName(), XmlParser.traverseDomTree(rootNode));
        if (rootNode.hasAttributes()) {
            retMap = XmlParser.makeAttrMapForEleNode(retMap, rootNode);
        }
        return retMap;
    }

    private static Object traverseDomTree(Node parentNode) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Object leafNode = null;
        NodeList childNodes = parentNode.getChildNodes();
        for (Node node : XmlParser.iterableNodeMap(childNodes)) {
            if (node.getNodeType() == 1) {
                leafNode = XmlParser.handleElementNode(node);
            } else if (node.getNodeType() == 3) {
                return XmlParser.handleTextNode(node);
            }
            XmlParser.updateNestedMap(retMap, node.getNodeName(), leafNode);
        }
        return retMap;
    }

    private static Object handleElementNode(Node node) {
        Map<String, Object> retNode = XmlParser.traverseDomTree(node);
        if (node.hasAttributes()) {
            retNode = XmlParser.makeAttrMapForEleNode(retNode, node);
        }
        return retNode;
    }

    private static Object handleTextNode(Node node) {
        if (node.getParentNode().hasAttributes()) {
            return XmlParser.makeAttrMapForTxtNode(node.getParentNode());
        }
        return node.getTextContent();
    }

    private static Map<String, Object> makeAttrMapForTxtNode(Node node) {
        NamedNodeMap nodeAttrs = node.getAttributes();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(TEXT, node.getTextContent());
        XmlParser.iterableNamedNodeMap(nodeAttrs).forEach(attr -> ret.put(attr.getNodeName(), attr.getTextContent()));
        return ret;
    }

    private static Map<String, Object> makeAttrMapForEleNode(Map<String, Object> eleMap, Node node) {
        HashMap<String, Object> ret = new HashMap();
        ret = eleMap;
        for (Node attr : XmlParser.iterableNamedNodeMap(node.getAttributes())) {
            ret.put(attr.getNodeName(), attr.getTextContent().trim());
        }
        return ret;
    }

    private static void updateNestedMap(Map<String, Object> map, String nodeName, Object leafNode) {
        if (map.containsKey(nodeName)) {
            Object nestedObj = map.get(nodeName);
            if (nestedObj instanceof List) {
                ((List)nestedObj).add(leafNode);
            } else if (!nodeName.equals(TEXT)) {
                ArrayList<Object> nestedObjList = new ArrayList<Object>();
                nestedObjList.add(nestedObj);
                nestedObjList.add(leafNode);
                map.put(nodeName, nestedObjList);
            }
        } else {
            map.put(nodeName, leafNode);
        }
    }

    private static Iterable<Node> iterableNodeMap(final NodeList nodeList) {
        return () -> new Iterator<Node>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < nodeList.getLength();
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return nodeList.item(this.index++);
            }
        };
    }

    private static Iterable<Node> iterableNamedNodeMap(final NamedNodeMap namedNodeMap) {
        return () -> new Iterator<Node>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < namedNodeMap.getLength();
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return namedNodeMap.item(this.index++);
            }
        };
    }
}

