/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.modelprovider;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;

public class VABPathTools {
    public static final String SEPERATOR = "/";

    public static String stripSlashes(String path) {
        while (path.startsWith(SEPERATOR)) {
            path = path.substring(1);
        }
        while (path.endsWith(SEPERATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String encodePathElement(String elem) {
        try {
            return URLEncoder.encode(elem, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodePathElement(String encodedElem) {
        try {
            return URLDecoder.decode(encodedElem, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String skipEntries(String path, int toSkip) {
        StringBuilder builder = new StringBuilder();
        String[] splitted = VABPathTools.splitPath(path);
        for (int i = toSkip; i < splitted.length; ++i) {
            builder.append(splitted[i]);
            if (i >= splitted.length - 1) continue;
            builder.append(SEPERATOR);
        }
        return builder.toString();
    }

    public static String getEntry(String path, int entry) {
        return VABPathTools.splitPath(path)[entry];
    }

    public static String[] splitPath(String path) {
        if (path == null) {
            return null;
        }
        if (VABPathTools.isEmptyPath(path)) {
            return new String[0];
        }
        String fixedPath = VABPathTools.removePrefix(path, SEPERATOR);
        String[] splitted = fixedPath.split(SEPERATOR);
        ArrayList<String> nonEmptySplitted = new ArrayList<String>();
        for (String s : splitted) {
            if (s.isEmpty()) continue;
            nonEmptySplitted.add(s);
        }
        return nonEmptySplitted.toArray(new String[nonEmptySplitted.size()]);
    }

    public static String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        if (VABPathTools.isEmptyPath(path)) {
            return "";
        }
        int lastIndex = path.lastIndexOf(SEPERATOR);
        if (lastIndex == path.length() - 1) {
            lastIndex = path.lastIndexOf(SEPERATOR, path.length() - 2);
        }
        if (lastIndex >= 0) {
            return VABPathTools.removePrefix(path.substring(0, lastIndex), SEPERATOR);
        }
        return "";
    }

    public static String getLastElement(String path) {
        if (path == null) {
            return null;
        }
        String[] elements = VABPathTools.splitPath(path);
        if (elements.length > 0) {
            return elements[elements.length - 1];
        }
        return "";
    }

    public static String removePrefix(String path, String prefix) {
        if (path == null) {
            return null;
        }
        if (VABPathTools.isEmptyPath(path)) {
            return "";
        }
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    public static String append(String path, String element) {
        if (path == null || element == null) {
            return null;
        }
        if (path.lastIndexOf(SEPERATOR) == path.length() - 1) {
            return path + element;
        }
        return path + SEPERATOR + element;
    }

    public static String buildPath(String[] pathElements, int startIndex) {
        if (pathElements == null) {
            return null;
        }
        if (startIndex >= pathElements.length) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < pathElements.length; ++i) {
            result.append(pathElements[i] + SEPERATOR);
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static boolean isOperationInvokationPath(String path) {
        if (path == null) {
            return false;
        }
        String[] pathElements = VABPathTools.splitPath(path);
        if (pathElements.length == 0) {
            return false;
        }
        return pathElements[pathElements.length - 1].startsWith("invoke") || VABPathTools.isOperationPath(path);
    }

    private static boolean isOperationPath(String path) {
        String lowerCasePath = path.toLowerCase();
        return lowerCasePath.startsWith("operations/") || path.toLowerCase().contains("/operations/");
    }

    public static boolean isEmptyPath(String path) {
        return path.equals("") || path.equals(SEPERATOR);
    }

    public static String getFirstEndpoint(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        if (VABPathTools.isEmptyPath(fullPath) || !fullPath.contains("//")) {
            return "";
        }
        String[] splitted = fullPath.split("//");
        return splitted[0] + "//" + splitted[1];
    }

    public static String removeFirstEndpoint(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        if (VABPathTools.isEmptyPath(fullPath)) {
            return "";
        }
        if (!fullPath.contains("//")) {
            return fullPath;
        }
        String firstEndpoint = fullPath.replaceFirst(VABPathTools.getFirstEndpoint(fullPath), "");
        if (firstEndpoint.startsWith("//")) {
            firstEndpoint = firstEndpoint.replaceFirst("//", "");
        }
        return firstEndpoint;
    }

    public static String concatenatePaths(String ... paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean isFirst = true;
        for (String pathSegment : paths) {
            if (pathSegment == null) {
                return null;
            }
            while (pathSegment.endsWith(SEPERATOR)) {
                pathSegment = pathSegment.substring(0, pathSegment.length() - 1);
            }
            while (pathSegment.startsWith(SEPERATOR)) {
                pathSegment = pathSegment.substring(1);
            }
            if (!isFirst) {
                result.append(SEPERATOR);
            } else {
                isFirst = false;
            }
            result.append(pathSegment);
        }
        return result.toString();
    }

    public static void checkPathForNull(String path) throws MalformedRequestException {
        if (path == null) {
            throw new MalformedRequestException("Path is not allowed to be null");
        }
    }

    public static String stripInvokeFromPath(String path) {
        if (path == null) {
            return null;
        }
        if (VABPathTools.getLastElement(path).startsWith("invoke")) {
            return VABPathTools.getParentPath(path);
        }
        return path;
    }

    public static String getPathFromURL(String url) {
        if (url == null) {
            return null;
        }
        if (url.contains("://")) {
            int index = url.indexOf(":") + 3;
            url = url.substring(index);
            index = url.indexOf(SEPERATOR);
            url = url.substring(index);
            return VABPathTools.getPathFromURL(url);
        }
        if (!url.startsWith(SEPERATOR)) {
            url = SEPERATOR + url;
        }
        return url;
    }

    public static String harmonizePathWithSuffix(String path, String suffix) {
        String strippedPath = VABPathTools.stripSlashes(path);
        String strippedSuffix = VABPathTools.stripSlashes(suffix);
        if (strippedPath.endsWith(SEPERATOR + strippedSuffix)) {
            return strippedPath;
        }
        return VABPathTools.concatenatePaths(strippedPath, strippedSuffix);
    }
}

