/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.server;

import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceAlreadyExistsException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class ExceptionToHTTPCodeMapper {
    public static int mapFromException(ProviderException e) {
        if (e instanceof MalformedRequestException) {
            return 400;
        }
        if (e instanceof ResourceAlreadyExistsException) {
            return 422;
        }
        if (e instanceof ResourceNotFoundException) {
            return 404;
        }
        return 500;
    }

    public static ProviderException mapToException(int statusCode, String text) {
        switch (statusCode) {
            case 400: {
                return new MalformedRequestException(text);
            }
            case 422: {
                return new ResourceAlreadyExistsException(text);
            }
            case 404: {
                return new ResourceNotFoundException(text);
            }
        }
        return new ProviderException(text);
    }
}

