/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.netcomm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.eclipse.basyx.components.netcomm.TCPCommunicator;

public class TCPClient
extends TCPCommunicator
implements Runnable {
    protected int port = -1;
    protected String serverName = null;
    protected boolean isBlocking = true;

    public TCPClient(int portNo) {
        this("localhost", portNo);
    }

    public TCPClient(String hostName, int portNo) {
        this.port = portNo;
        try {
            InetAddress hostIPAddress = InetAddress.getByName(hostName);
            this.communicationToClient = SocketChannel.open();
            this.communicationToClient.configureBlocking(true);
            this.communicationToClient.connect(new InetSocketAddress(hostIPAddress, this.port));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void makeNonBlocking() {
        this.isBlocking = false;
        try {
            this.communicationToClient.configureBlocking(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (!this.isBlocking) {
            throw new RuntimeException("TCP client communication thread may only be used on blocking sockets.");
        }
        while (true) {
            byte[] message;
            if ((message = this.readMessage()) == null) {
                continue;
            }
            this.notifyListeners(message);
        }
    }
}

