/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.tools.propertyfile.opdef;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFilter {
    private static Logger logger = LoggerFactory.getLogger(ResultFilter.class);

    public static Set<String> stringSet(ResultSet sqlResult, Object ... columnName) {
        HashSet<String> result = new HashSet<String>();
        try {
            while (sqlResult.next()) {
                result.add(sqlResult.getString((String)columnName[0]));
            }
        }
        catch (SQLException e) {
            logger.error("Could not get string set from sqlResult", (Throwable)e);
        }
        return result;
    }

    public static Object stringArray(ResultSet sqlResult, Object ... columnName) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            while (sqlResult.next()) {
                result.add(sqlResult.getString((String)columnName[0]));
            }
        }
        catch (SQLException e) {
            logger.error("Could not get string collection from sqlResult", (Throwable)e);
        }
        return result;
    }

    public static Object mapArray(ResultSet sqlResult, Object ... columnNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            while (sqlResult.next()) {
                for (Object columnName : columnNames) {
                    result.put((String)columnName, sqlResult.getString((String)columnName));
                }
            }
        }
        catch (SQLException e) {
            logger.error("Could not get map from sqlResult", (Throwable)e);
        }
        return result;
    }

    public static Object listOfMaps(ResultSet sqlResult, Object ... columnNames) {
        LinkedList result = new LinkedList();
        try {
            while (sqlResult.next()) {
                HashMap<String, String> listElement = new HashMap<String, String>();
                for (Object columnName : columnNames) {
                    listElement.put((String)columnName, sqlResult.getString((String)columnName));
                }
                result.add(listElement);
            }
        }
        catch (SQLException e) {
            logger.error("Could not get list from sqlResult", (Throwable)e);
        }
        return result;
    }
}

