/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.sqlproxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.tools.sqlproxy.SQLCollection;
import org.eclipse.basyx.tools.sqlproxy.SQLMap;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.eclipse.basyx.tools.sqlproxy.exception.UnknownElementTypeException;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;

public class SQLTableRow {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_NULL = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_CHARACTER = 4;
    public static final int TYPE_STRING = 5;
    public static final int TYPE_BOOLEAN = 6;
    public static final int TYPE_INTARRAY = 10;
    public static final int TYPE_FLOATARRAY = 11;
    public static final int TYPE_DOUBLEARRAY = 12;
    public static final int TYPE_CHARACTERARRAY = 13;
    public static final int TYPE_STRINGARRAY = 14;
    public static final int TYPE_BOOLEANARRAY = 15;
    public static final int TYPE_SQLCOLLECTION = 20;
    public static final int TYPE_SQLMAP = 21;
    public static final int TYPE_EXCEPTION = 22;
    public static final int TYPE_GENERICCOLLECTION = 23;
    public static final int TYPE_GENERICMAP = 24;
    protected static GSONTools serializer = new GSONTools((GSONToolsFactory)new DefaultTypeFactory());
    private String entryName;
    private Object entryValue;
    private String entryValueAsString;
    private int entryType = -1;

    public SQLTableRow(Object value) {
        this.entryValue = value;
        this.entryName = null;
        this.entryValueAsString = SQLTableRow.getValueAsString(value);
        this.entryType = SQLTableRow.getTypeID(value);
    }

    public SQLTableRow(String name, Object value) {
        this.entryName = name;
        this.entryValue = value;
        this.entryValueAsString = SQLTableRow.getValueAsString(value);
        this.entryType = SQLTableRow.getTypeID(value);
    }

    public SQLTableRow(SQLRootElement rootElement, String name, int typeId, String valueAsString) {
        this.entryName = name;
        this.entryType = typeId;
        this.entryValueAsString = valueAsString;
        this.entryValue = SQLTableRow.getValueFromString(rootElement, typeId, valueAsString);
    }

    protected static String serializeToString(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutput);
            outputStream.writeObject(object);
            return Base64.getEncoder().encodeToString(byteArrayOutput.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String serializeSQLMapToString(SQLMap value) {
        return value.getSqlTableID();
    }

    protected static String serializeSQLCollectionToString(SQLCollection value) {
        return value.getSqlTableID();
    }

    protected static String serializeGenericMapToString(Map<?, ?> value) {
        return serializer.serialize(value);
    }

    protected static String serializeGenericCollectionToString(Collection<?> value) {
        return serializer.serialize(value);
    }

    protected static Object deserializeFromString(String serializedObject) {
        byte[] objectInBytes = Base64.getDecoder().decode(serializedObject);
        try {
            ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(objectInBytes));
            return inputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static SQLMap deserializeSQLMapFromString(SQLRootElement rootElement, String serializedObject) {
        return new SQLMap(rootElement, serializedObject);
    }

    protected static SQLCollection deserializeSQLCollectionFromString(SQLRootElement rootElement, String serializedObject) {
        return new SQLCollection(rootElement, serializedObject);
    }

    protected static Collection<Object> deserializeGenericCollectionFromString(String serializedObject) {
        return (Collection)serializer.deserialize(serializedObject);
    }

    protected static Map<String, Object> deserializeGenericMapFromString(String serializedObject) {
        return (Map)serializer.deserialize(serializedObject);
    }

    public static String getValueAsString(Object value) {
        int typeId = SQLTableRow.getTypeID(value);
        switch (typeId) {
            case 0: {
                return "(null)";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return value.toString();
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return SQLTableRow.serializeToString(value);
            }
            case 20: {
                return SQLTableRow.serializeSQLCollectionToString((SQLCollection)value);
            }
            case 21: {
                return SQLTableRow.serializeSQLMapToString((SQLMap)value);
            }
            case 23: {
                return SQLTableRow.serializeGenericCollectionToString((Collection)value);
            }
            case 24: {
                return SQLTableRow.serializeGenericMapToString((Map)value);
            }
        }
        throw new UnknownElementTypeException("");
    }

    public static Object getValueFromString(SQLRootElement rootElement, int typeId, String valAsString) {
        switch (typeId) {
            case 0: {
                return null;
            }
            case 1: {
                return Integer.parseInt(valAsString);
            }
            case 2: {
                return Float.valueOf(Float.parseFloat(valAsString));
            }
            case 3: {
                return Double.parseDouble(valAsString);
            }
            case 5: {
                return valAsString;
            }
            case 6: {
                return Boolean.parseBoolean(valAsString);
            }
            case 4: {
                return Character.valueOf(valAsString.charAt(0));
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return SQLTableRow.deserializeFromString(valAsString);
            }
            case 20: {
                return SQLTableRow.deserializeSQLCollectionFromString(rootElement, valAsString);
            }
            case 21: {
                return SQLTableRow.deserializeSQLMapFromString(rootElement, valAsString);
            }
            case 23: {
                return SQLTableRow.deserializeGenericCollectionFromString(valAsString);
            }
            case 24: {
                return SQLTableRow.deserializeGenericMapFromString(valAsString);
            }
        }
        return null;
    }

    protected static int getTypeID(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return 1;
        }
        if (value instanceof Float) {
            return 2;
        }
        if (value instanceof Double) {
            return 3;
        }
        if (value instanceof String) {
            return 5;
        }
        if (value instanceof Boolean) {
            return 6;
        }
        if (value instanceof Character) {
            return 4;
        }
        if (value instanceof int[]) {
            return 10;
        }
        if (value instanceof Integer[]) {
            return 10;
        }
        if (value instanceof float[]) {
            return 11;
        }
        if (value instanceof Float[]) {
            return 11;
        }
        if (value instanceof double[]) {
            return 12;
        }
        if (value instanceof Double[]) {
            return 12;
        }
        if (value instanceof char[]) {
            return 13;
        }
        if (value instanceof Character[]) {
            return 13;
        }
        if (value instanceof boolean[]) {
            return 15;
        }
        if (value instanceof Boolean[]) {
            return 15;
        }
        if (value instanceof String[]) {
            return 14;
        }
        if (value instanceof SQLMap) {
            return 21;
        }
        if (value instanceof SQLCollection) {
            return 20;
        }
        if (value instanceof Map) {
            return 24;
        }
        if (value instanceof Collection) {
            return 23;
        }
        if (value instanceof Exception) {
            return 22;
        }
        return -1;
    }

    public String getName() {
        return this.entryName;
    }

    public Object getValue() {
        return this.entryValue;
    }

    public String getValueAsString() {
        return this.entryValueAsString;
    }

    public int getTypeID() {
        return this.entryType;
    }
}

