/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.autoregistration;

import java.util.Collection;
import org.eclipse.basyx.aas.aggregator.AASAggregatorAPIHelper;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.MultiSubmodelProvider;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregator;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;

public class AutoRegisterSubmodelAggregator
implements ISubmodelAggregator {
    private IIdentifier aasIdentifier;
    private ISubmodelAggregator aggregator;
    private IAASRegistry registry;
    private String endpoint;

    public AutoRegisterSubmodelAggregator(ISubmodelAggregator aggregator, IAASRegistry registry, IIdentifier aasIdentifier, String endpoint) {
        this.aggregator = aggregator;
        this.registry = registry;
        this.aasIdentifier = aasIdentifier;
        this.endpoint = endpoint;
    }

    public Collection<ISubmodel> getSubmodelList() {
        return this.aggregator.getSubmodelList();
    }

    public ISubmodel getSubmodel(IIdentifier identifier) throws ResourceNotFoundException {
        return this.aggregator.getSubmodel(identifier);
    }

    public ISubmodel getSubmodelbyIdShort(String idShort) throws ResourceNotFoundException {
        return this.aggregator.getSubmodelbyIdShort(idShort);
    }

    public ISubmodelAPI getSubmodelAPIById(IIdentifier identifier) throws ResourceNotFoundException {
        return this.aggregator.getSubmodelAPIById(identifier);
    }

    public ISubmodelAPI getSubmodelAPIByIdShort(String idShort) throws ResourceNotFoundException {
        return this.aggregator.getSubmodelAPIByIdShort(idShort);
    }

    public void createSubmodel(Submodel submodel) {
        this.aggregator.createSubmodel(submodel);
        this.registry.register(this.aasIdentifier, new SubmodelDescriptor((ISubmodel)submodel, this.getEndpoint((ISubmodel)submodel)));
    }

    public void createSubmodel(ISubmodelAPI submodelAPI) {
        this.aggregator.createSubmodel(submodelAPI);
        this.registry.register(this.aasIdentifier, new SubmodelDescriptor(submodelAPI.getSubmodel(), this.getEndpoint(submodelAPI.getSubmodel())));
    }

    private String getEndpoint(ISubmodel submodel) {
        String harmonized = AASAggregatorAPIHelper.harmonizeURL((String)this.endpoint);
        String shellEntryPath = AASAggregatorAPIHelper.getAASEntryPath((IIdentifier)this.aasIdentifier);
        String submodelEntryPath = VABPathTools.concatenatePaths((String[])new String[]{MultiSubmodelProvider.SUBMODELS_PREFIX, submodel.getIdShort(), "submodel"});
        return VABPathTools.concatenatePaths((String[])new String[]{harmonized, shellEntryPath, submodelEntryPath});
    }

    public void updateSubmodel(Submodel submodel) throws ResourceNotFoundException {
        this.aggregator.updateSubmodel(submodel);
    }

    public void deleteSubmodelByIdentifier(IIdentifier identifier) {
        this.aggregator.deleteSubmodelByIdentifier(identifier);
        this.registry.delete(this.aasIdentifier, identifier);
    }

    public void deleteSubmodelByIdShort(String idShort) {
        Submodel submodel = (Submodel)this.aggregator.getSubmodelbyIdShort(idShort);
        this.aggregator.deleteSubmodelByIdShort(idShort);
        this.registry.delete(this.aasIdentifier, submodel.getIdentification());
    }
}

