/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.fileadaptation;

import java.util.List;
import java.util.Optional;
import org.eclipse.basyx.aas.aggregator.AASAggregatorAPIHelper;
import org.eclipse.basyx.aas.metamodel.map.descriptor.CustomId;
import org.eclipse.basyx.components.aas.fileadaptation.FileValueAdaptingSubmodelAPI;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileValueAdaptingSubmodelAPIFactory
implements ISubmodelAPIFactory {
    private static Logger logger = LoggerFactory.getLogger(FileValueAdaptingSubmodelAPIFactory.class);
    private String serverUrl;
    private ISubmodelAPIFactory submodelApiFactory;

    public FileValueAdaptingSubmodelAPIFactory(ISubmodelAPIFactory submodelApiFactory, String serverUrl) {
        this.serverUrl = serverUrl;
        this.submodelApiFactory = submodelApiFactory;
    }

    public ISubmodelAPI getSubmodelAPI(Submodel submodel) {
        String aasId = this.getAasIdentifier(submodel);
        return new FileValueAdaptingSubmodelAPI(this.submodelApiFactory.create(submodel), FileValueAdaptingSubmodelAPIFactory.getSubmodelUrl(this.serverUrl, aasId, submodel.getIdShort()));
    }

    private String getAasIdentifier(Submodel submodel) {
        List keys;
        Optional<IKey> aasKey;
        IReference reference = submodel.getParent();
        if (reference != null && reference.getKeys() != null && reference.getKeys().size() > 0 && (aasKey = (keys = reference.getKeys()).stream().filter(k -> k.getType().equals((Object)KeyElements.ASSETADMINISTRATIONSHELL)).findAny()).isPresent()) {
            return aasKey.get().getValue();
        }
        logger.error("Submodel with id " + submodel.getIdentification() + " does not have a parent. The automatic setting of FileValues may lead to unexpected results.");
        return "";
    }

    private static String getSubmodelUrl(String serverUrl, String aasId, String submodelIdShort) {
        String aasAccessPath = AASAggregatorAPIHelper.getAASAccessPath((IIdentifier)new CustomId(aasId));
        return VABPathTools.concatenatePaths((String[])new String[]{serverUrl, aasAccessPath, "submodels", submodelIdShort, "submodel"});
    }
}

