/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.factory.propertymap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.bundle.AASBundleFactory;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.components.factory.propertymap.PropertyMapBasedAASFactory;
import org.eclipse.basyx.components.factory.propertymap.PropertyMapBasedAssetFactory;
import org.eclipse.basyx.components.factory.propertymap.PropertyMapBasedPropertyFactory;
import org.eclipse.basyx.components.factory.propertymap.PropertyMapBasedSubmodelFactory;
import org.eclipse.basyx.components.propertymap.PropertyMapHelper;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;

public class PropertyMapBasedAASBundlesFactory {
    public static final String SHELLS = "shells";
    public static final String ASSETS = "assets";
    public static final String SUBMODELS = "submodels";
    public static final String PROPERTIES = "properties";
    private PropertyMapBasedAssetFactory assetFactory = new PropertyMapBasedAssetFactory();
    private PropertyMapBasedPropertyFactory propertyFactory = new PropertyMapBasedPropertyFactory();

    public Set<AASBundle> create(Map<String, Object> properties) {
        Map<String, Asset> assets = this.getAssets(properties);
        Map<String, Property> submodelProperties = this.getSubmodelProperties(properties);
        Map<String, Submodel> submodels = PropertyMapBasedAASBundlesFactory.getSubmodels(properties, submodelProperties);
        List<AssetAdministrationShell> shells = PropertyMapBasedAASBundlesFactory.getAssetAdministrationShells(properties, submodels, assets);
        return new AASBundleFactory().create(shells, submodels.values(), assets.values());
    }

    private static List<AssetAdministrationShell> getAssetAdministrationShells(Map<String, Object> properties, Map<String, Submodel> submodels, Map<String, Asset> assets) {
        PropertyMapBasedAASFactory aasFactory = new PropertyMapBasedAASFactory(submodels, assets);
        return PropertyMapBasedAASBundlesFactory.getAASIds(properties).stream().map(id -> PropertyMapBasedAASBundlesFactory.getAASMap(id, properties)).map(aasFactory::create).collect(Collectors.toList());
    }

    private static Map<String, String> getAASMap(String id, Map<String, Object> properties) {
        return (Map)properties.get(id);
    }

    private static Map<String, Submodel> getSubmodels(Map<String, Object> properties, Map<String, Property> submodelProperties) {
        HashMap<String, Submodel> ret = new HashMap<String, Submodel>();
        PropertyMapBasedSubmodelFactory submodelFactory = new PropertyMapBasedSubmodelFactory(submodelProperties);
        for (String id : PropertyMapBasedAASBundlesFactory.getSubmodelIds(properties)) {
            Submodel submodel = PropertyMapBasedAASBundlesFactory.getSubmodel(properties, submodelFactory, id);
            ret.put(id, submodel);
        }
        return ret;
    }

    private static Submodel getSubmodel(Map<String, Object> properties, PropertyMapBasedSubmodelFactory submodelFactory, String id) {
        Map<String, String> submodelMap = PropertyMapBasedAASBundlesFactory.getSubmodelMap(id, properties);
        Submodel submodel = submodelFactory.create(submodelMap);
        return submodel;
    }

    private static Map<String, String> getSubmodelMap(String id, Map<String, Object> properties) {
        return (Map)properties.get(id);
    }

    private static List<String> getSubmodelIds(Map<String, Object> properties) {
        String submodelIdList = PropertyMapBasedAASBundlesFactory.getSubmodelStringList(properties);
        return PropertyMapHelper.getListFromStringList(submodelIdList);
    }

    private static String getSubmodelStringList(Map<String, Object> properties) {
        return (String)properties.get(SUBMODELS);
    }

    private Map<String, Property> getSubmodelProperties(Map<String, Object> properties) {
        HashMap<String, Property> ret = new HashMap<String, Property>();
        for (String id : PropertyMapBasedAASBundlesFactory.getPropertyIds(properties)) {
            ret.put(id, this.getProperty(id, properties));
        }
        return ret;
    }

    private Property getProperty(String id, Map<String, Object> properties) {
        Map propertyMap = (Map)properties.get(id);
        return this.propertyFactory.create(propertyMap);
    }

    private static String getPropertyIdString(Map<String, Object> properties) {
        return (String)properties.get(PROPERTIES);
    }

    private Map<String, Asset> getAssets(Map<String, Object> properties) {
        HashMap<String, Asset> ret = new HashMap<String, Asset>();
        for (String id : PropertyMapBasedAASBundlesFactory.getAssetIds(properties)) {
            ret.put(id, this.getAsset(id, properties));
        }
        return ret;
    }

    private Asset getAsset(String id, Map<String, Object> properties) {
        Map assetMap = (Map)properties.get(id);
        return this.assetFactory.create(assetMap);
    }

    private static List<String> getAssetIds(Map<String, Object> properties) {
        String assetStringList = PropertyMapBasedAASBundlesFactory.getAssetIdString(properties);
        return PropertyMapHelper.getListFromStringList(assetStringList);
    }

    private static String getAssetIdString(Map<String, Object> properties) {
        return (String)properties.get(ASSETS);
    }

    private static List<String> getAASIds(Map<String, Object> properties) {
        String aasStringList = PropertyMapBasedAASBundlesFactory.getAASIdString(properties);
        return PropertyMapHelper.getListFromStringList(aasStringList);
    }

    private static List<String> getPropertyIds(Map<String, Object> properties) {
        String propertyStringList = PropertyMapBasedAASBundlesFactory.getPropertyIdString(properties);
        return PropertyMapHelper.getListFromStringList(propertyStringList);
    }

    private static String getAASIdString(Map<String, Object> properties) {
        return (String)properties.get(SHELLS);
    }
}

