/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.sqlproxy;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.tools.sql.driver.ISQLDriver;
import org.eclipse.basyx.tools.sql.query.DynamicSQLQuery;
import org.eclipse.basyx.tools.sql.query.DynamicSQLUpdate;
import org.eclipse.basyx.tools.sqlproxy.SQLConnector;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.eclipse.basyx.tools.sqlproxy.SQLTableRow;

public abstract class SQLProxy
extends SQLConnector {
    protected SQLRootElement sqlRootElement = null;

    public SQLProxy(ISQLDriver driver, String tableID, SQLRootElement rootElement) {
        super(driver, tableID);
        this.sqlRootElement = rootElement;
    }

    protected int getSize(ResultSet set) {
        int counter = 0;
        try {
            while (set.next()) {
                ++counter;
            }
            return counter;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    protected void addToMapSimple(String mapName, SQLTableRow sqlMapElement) {
        this.addToMapSimple(this.getDriver(), mapName, sqlMapElement);
    }

    protected void addToMapSimple(ISQLDriver drv, String mapName, SQLTableRow sqlMapElement) {
        String updateString = "INSERT INTO elements." + mapName + " (name, value, type) VALUES ('$name', '$value', '$type')";
        DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(drv, updateString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("name", sqlMapElement.getName());
        parameter.put("value", sqlMapElement.getValueAsString());
        parameter.put("type", sqlMapElement.getTypeID());
        dynUpdate.accept((Map<String, Object>)parameter);
    }

    protected void addToCollectionSimple(String collectionName, SQLTableRow sqlCollectionElement) {
        this.addToCollectionSimple(this.getDriver(), collectionName, sqlCollectionElement);
    }

    protected void addToCollectionSimple(ISQLDriver drv, String collectionName, SQLTableRow sqlCollectionElement) {
        String updateString = "INSERT INTO elements." + collectionName + " (value, type) VALUES ('$value', '$type')";
        DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(drv, updateString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("value", sqlCollectionElement.getValueAsString());
        parameter.put("type", sqlCollectionElement.getTypeID());
        dynUpdate.accept((Map<String, Object>)parameter);
    }

    protected void addToMapMultiple(String mapName, Collection<SQLTableRow> values) {
        this.addToMapMultiple(this.getDriver(), mapName, values);
    }

    protected void addToMapMultiple(ISQLDriver drv, String mapName, Collection<SQLTableRow> values) {
        StringBuffer valueVariables = new StringBuffer();
        boolean firstEntry = true;
        for (int i = 0; i < values.size(); ++i) {
            if (firstEntry) {
                valueVariables.append("('$name" + i + "', '$value" + i + "', '$type" + i + "')");
                firstEntry = false;
                continue;
            }
            valueVariables.append(", ('$name" + i + "', '$value" + i + "', '$type" + i + "')");
        }
        String updateString = "INSERT INTO elements." + mapName + " (name, value, type) VALUES " + valueVariables.toString();
        DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(drv, updateString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        int counter = 0;
        for (SQLTableRow value : values) {
            parameter.put("name" + counter, value.getName());
            parameter.put("value" + counter, value.getValueAsString());
            parameter.put("type" + counter, value.getTypeID());
            ++counter;
        }
        dynUpdate.accept((Map<String, Object>)parameter);
    }

    protected void updateInMapSimple(String mapName, SQLTableRow sqlMapElement) {
        this.updateInMapSimple(this.getDriver(), mapName, sqlMapElement);
    }

    protected void updateInMapSimple(ISQLDriver drv, String mapName, SQLTableRow sqlMapElement) {
        String updateString = "UPDATE elements." + mapName + " SET value='$value', type='$type' WHERE name='$name'";
        DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(this.getDriver(), updateString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("name", sqlMapElement.getName());
        parameter.put("value", sqlMapElement.getValueAsString());
        parameter.put("type", sqlMapElement.getTypeID());
        dynUpdate.accept((Map<String, Object>)parameter);
    }

    protected void removeAllKeys(Set<String> keys) {
        this.removeAllKeys(this.getDriver(), keys);
    }

    protected void removeAllKeys(ISQLDriver drv, Set<String> keys) {
        StringBuffer idList = new StringBuffer();
        boolean firstElement = true;
        for (String key : keys) {
            if (firstElement) {
                idList.append("'" + key + "'");
                firstElement = false;
                continue;
            }
            idList.append(", '" + key + "'");
        }
        String updateString = "DELETE FROM elements." + this.getSqlTableID() + " WHERE name IN (" + idList.toString() + ")";
        DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(drv, updateString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynUpdate.accept((Map<String, Object>)parameter);
    }

    protected Object getValueFromMap(String mapName, String key) {
        return this.getValueFromMap(this.getDriver(), mapName, key);
    }

    protected Object getValueFromMap(ISQLDriver drv, String mapName, String key) {
        String queryString = "SELECT * FROM elements." + mapName + " WHERE name='$name'";
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(drv, queryString, "mapArray(name:String,value:String,type:Integer)");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("name", key);
        Map result = (Map)dynQuery.get(parameter);
        if (result.get("type") == null) {
            return null;
        }
        return SQLTableRow.getValueFromString(this.sqlRootElement, (Integer)result.get("type"), (String)result.get("value"));
    }

    protected Object getMapRowRaw(String mapName, String key) {
        return this.getMapRowRaw(this.getDriver(), mapName, key);
    }

    protected Object getMapRowRaw(ISQLDriver drv, String mapName, String key) {
        String queryString = "SELECT * FROM elements." + mapName + " WHERE name='$name'";
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(drv, queryString, "mapArray(name:String,value:String,type:Integer)");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("name", key);
        return dynQuery.get(parameter);
    }

    protected Object getSingleMapColumnRaw(String mapName, String columnName) {
        return this.getSingleMapColumnRaw(this.getDriver(), mapName, columnName);
    }

    protected Object getSingleMapColumnRaw(ISQLDriver drv, String mapName, String columnName) {
        String queryString = "SELECT " + columnName + " FROM elements." + mapName;
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(drv, queryString, "stringSet(" + columnName + ":String)");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        return dynQuery.get(parameter);
    }

    protected Object getMapColumnRaw(String mapName, String ... columnNames) {
        return this.getMapColumnRaw(this.getDriver(), mapName, columnNames);
    }

    protected Object getMapColumnRaw(ISQLDriver drv, String mapName, String ... columnNames) {
        StringBuffer nameList = new StringBuffer();
        StringBuffer parameterList = new StringBuffer();
        boolean firstElement = true;
        for (String name : columnNames) {
            if (firstElement) {
                nameList.append(name);
                parameterList.append(name + ":String");
                firstElement = false;
                continue;
            }
            nameList.append(", " + name);
            parameterList.append(", " + name + ":String");
        }
        String queryString = "SELECT " + nameList + " FROM elements." + mapName;
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(drv, queryString, "listOfMaps(" + parameterList.toString() + ")");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        return dynQuery.get(parameter);
    }
}

