/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.restapi;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.aas.restapi.vab.VABAASAPI;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.NotAnInvokableException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.lambda.VABLambdaProvider;

public class AASModelProvider
implements IModelProvider {
    private IAASAPI aasApi;

    public AASModelProvider(IModelProvider modelProvider) {
        this.aasApi = new VABAASAPI(modelProvider);
    }

    public AASModelProvider(AssetAdministrationShell shell) {
        this.aasApi = new VABAASAPI(new VABLambdaProvider(shell));
    }

    public AASModelProvider(IAASAPI aasApi) {
        this.aasApi = aasApi;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        if ((path = this.preparePath(path)).isEmpty()) {
            AssetAdministrationShell value = this.addAssetReferenceInAAS(this.aasApi.getAAS());
            return value;
        }
        throw new MalformedRequestException("Path " + path + " is not supported");
    }

    private AssetAdministrationShell addAssetReferenceInAAS(Object value) {
        AssetAdministrationShell aas = (AssetAdministrationShell)value;
        Map asset = (Map)aas.get("asset");
        Map<String, Object> assetMap = this.addAssetReferenceToAsset(asset);
        aas.put("asset", assetMap);
        return aas;
    }

    private Map<String, Object> addAssetReferenceToAsset(Map<String, Object> asset) {
        Reference assetReference = this.createAssetReference(asset);
        LinkedHashMap<String, Object> modifiedAsset = new LinkedHashMap<String, Object>();
        modifiedAsset.put("keys", assetReference.getKeys());
        modifiedAsset.putAll(asset);
        return modifiedAsset;
    }

    private Reference createAssetReference(Map<String, Object> asset) {
        Map assetIdMap = (Map)asset.get("identification");
        String idType = (String)assetIdMap.get("idType");
        String id = (String)assetIdMap.get("id");
        Identifier assetId = new Identifier(IdentifierType.fromString(idType), id);
        return new Reference(assetId, KeyElements.ASSET, true);
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        throw new MalformedRequestException("For an AAS, Set is not supported");
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        if (!(path = this.preparePath(path)).equals("submodels")) {
            throw new MalformedRequestException("Path " + path + " is not supported");
        }
        Map smMap = (Map)newEntity;
        Submodel sm = Submodel.createAsFacade(smMap);
        this.aasApi.removeSubmodel(sm.getIdentification().getId());
        this.aasApi.addSubmodel(sm.getReference());
    }

    private String preparePath(String path) {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        return path;
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        String[] splitted = VABPathTools.splitPath(path = this.preparePath(path));
        if (splitted.length != 3 || !splitted[1].equals("submodels")) {
            throw new MalformedRequestException("Delete on path " + path + " is not supported");
        }
        String id = VABPathTools.decodePathElement(splitted[2]);
        this.aasApi.removeSubmodel(id);
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete with parameter is not supported");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        throw new NotAnInvokableException("An AAS does not contain any operations that can be invoked");
    }
}

