/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.restapi.observing;

import java.util.stream.Stream;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.aas.restapi.observing.IAASAPIObserver;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.observer.Observable;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;

public class ObservableAASAPI
extends Observable<IAASAPIObserver>
implements IAASAPI {
    private IAASAPI aasAPI;

    public ObservableAASAPI(IAASAPI observedAPI) {
        this.aasAPI = observedAPI;
    }

    @Override
    public IAssetAdministrationShell getAAS() {
        return this.aasAPI.getAAS();
    }

    @Override
    public void addSubmodel(IReference submodel) {
        if (!this.containsSubmodelReference(submodel)) {
            throw new MalformedRequestException("Reference has to contain a submodel");
        }
        this.aasAPI.addSubmodel(submodel);
        this.observers.stream().forEach(o -> o.submodelAdded(submodel));
    }

    @Override
    public void removeSubmodel(String id) {
        this.aasAPI.removeSubmodel(id);
        this.observers.stream().forEach(o -> o.submodelRemoved(id));
    }

    private boolean containsSubmodelReference(IReference submodel) {
        Stream<IKey> filtered = submodel.getKeys().stream().filter(o -> o.getType().name().equalsIgnoreCase(KeyElements.SUBMODEL.getStandardizedLiteral()));
        return filtered.count() > 0L;
    }
}

