/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.aggregator.authorization.internal;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.extensions.shared.authorization.internal.ElevatedCodeAuthentication;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.extensions.submodel.aggregator.authorization.internal.ISubmodelAggregatorAuthorizer;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregator;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IIdentifiable;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedSubmodelAggregator<SubjectInformationType>
implements ISubmodelAggregator {
    private static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:sm-aggregator:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:sm-aggregator:write";
    private static final Logger logger = LoggerFactory.getLogger(AuthorizedSubmodelAggregator.class);
    protected final IAssetAdministrationShell aas;
    protected final ISubmodelAggregator decoratedSubmodelAggregator;
    protected final ISubmodelAggregatorAuthorizer<SubjectInformationType> submodelAggregatorAuthorizer;
    protected final ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider;

    public AuthorizedSubmodelAggregator(IAssetAdministrationShell aas, ISubmodelAggregator decoratedSubmodelAggregator, ISubmodelAggregatorAuthorizer<SubjectInformationType> submodelAggregatorAuthorizer, ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider) {
        this.aas = aas;
        this.decoratedSubmodelAggregator = decoratedSubmodelAggregator;
        this.submodelAggregatorAuthorizer = submodelAggregatorAuthorizer;
        this.subjectInformationProvider = subjectInformationProvider;
    }

    public AuthorizedSubmodelAggregator(ISubmodelAggregator decoratedSubmodelAggregator, ISubmodelAggregatorAuthorizer<SubjectInformationType> submodelAggregatorAuthorizer, ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider) {
        this(null, decoratedSubmodelAggregator, submodelAggregatorAuthorizer, subjectInformationProvider);
    }

    @Override
    public Collection<ISubmodel> getSubmodelList() {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAggregator.getSubmodelList();
        }
        try {
            return this.authorizeGetSubmodelList();
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Collection<ISubmodel> authorizeGetSubmodelList() throws InhibitException {
        return this.getSubmodelIdentifierList().stream().map(smId -> {
            try {
                return this.authorizeGetSubmodel((IIdentifier)smId);
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Collection<IIdentifier> getSubmodelIdentifierList() throws InhibitException {
        Collection<ISubmodel> authorizedSubmodelList = this.submodelAggregatorAuthorizer.authorizeGetSubmodelList(this.subjectInformationProvider.get(), this.aas, this.decoratedSubmodelAggregator::getSubmodelList);
        return authorizedSubmodelList.stream().map(IIdentifiable::getIdentification).collect(Collectors.toList());
    }

    @Override
    public ISubmodel getSubmodel(IIdentifier identifier) throws ResourceNotFoundException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAggregator.getSubmodel(identifier);
        }
        try {
            return this.authorizeGetSubmodel(identifier);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected ISubmodel authorizeGetSubmodel(IIdentifier smId) throws ResourceNotFoundException, InhibitException {
        ISubmodel sm = this.getSmUnsecured(smId);
        IReference smSemanticId = this.getSmSemanticIdUnsecured(sm);
        return this.submodelAggregatorAuthorizer.authorizeGetSubmodel(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, () -> this.decoratedSubmodelAggregator.getSubmodel(smId));
    }

    @Override
    public ISubmodel getSubmodelbyIdShort(String smIdShortPath) throws ResourceNotFoundException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAggregator.getSubmodelbyIdShort(smIdShortPath);
        }
        try {
            return this.authorizeGetSubmodelbyIdShort(smIdShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected ISubmodel authorizeGetSubmodelbyIdShort(String smIdShortPath) throws ResourceNotFoundException, InhibitException {
        ISubmodel sm = this.getSmUnsecured(smIdShortPath);
        IIdentifier smId = this.getSmIdUnsecured(sm);
        IReference smSemanticId = this.getSmSemanticIdUnsecured(sm);
        return this.submodelAggregatorAuthorizer.authorizeGetSubmodelbyIdShort(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, () -> this.decoratedSubmodelAggregator.getSubmodelbyIdShort(smIdShortPath));
    }

    @Override
    public ISubmodelAPI getSubmodelAPIById(IIdentifier identifier) throws ResourceNotFoundException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAggregator.getSubmodelAPIById(identifier);
        }
        try {
            return this.authorizeGetSubmodelAPIById(identifier);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected ISubmodelAPI authorizeGetSubmodelAPIById(IIdentifier smId) throws ResourceNotFoundException, InhibitException {
        ISubmodel sm = this.getSmUnsecured(smId);
        IReference smSemanticId = this.getSmSemanticIdUnsecured(sm);
        return this.submodelAggregatorAuthorizer.authorizeGetSubmodelAPIById(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, () -> this.decoratedSubmodelAggregator.getSubmodelAPIById(smId));
    }

    @Override
    public ISubmodelAPI getSubmodelAPIByIdShort(String smIdShortPath) throws ResourceNotFoundException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAggregator.getSubmodelAPIByIdShort(smIdShortPath);
        }
        try {
            return this.authorizeGetSubmodelAPIByIdShort(smIdShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected ISubmodelAPI authorizeGetSubmodelAPIByIdShort(String smIdShortPath) throws ResourceNotFoundException, InhibitException {
        ISubmodel sm = this.getSmUnsecured(smIdShortPath);
        IIdentifier smId = this.getSmIdUnsecured(sm);
        IReference smSemanticId = this.getSmSemanticIdUnsecured(sm);
        try {
            try {
                return this.submodelAggregatorAuthorizer.authorizeGetSubmodelAPIByIdShort(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, () -> this.decoratedSubmodelAggregator.getSubmodelAPIByIdShort(smIdShortPath));
            }
            catch (InhibitException inhibitException) {
                throw inhibitException.reduceSmIdToSmIdShortPath(smIdShortPath);
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            ModelUrn anySmId = new ModelUrn("*");
            Reference anySemanticSmId = new Reference(new Key(KeyElements.SUBMODEL, true, "*", IdentifierType.CUSTOM));
            this.submodelAggregatorAuthorizer.authorizeGetSubmodelAPIById(this.subjectInformationProvider.get(), this.aas, anySmId, anySemanticSmId, () -> null);
            throw resourceNotFoundException;
        }
    }

    @Override
    public void createSubmodel(Submodel submodel) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAggregator.createSubmodel(submodel);
            return;
        }
        try {
            this.authorizeCreateSubmodel(submodel.getIdentification());
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedSubmodelAggregator.createSubmodel(submodel);
    }

    protected void authorizeCreateSubmodel(IIdentifier smId) throws InhibitException {
        ISubmodel sm = this.getSmUnsecured(smId);
        IReference smSemanticId = this.getSmSemanticIdUnsecured(sm);
        this.submodelAggregatorAuthorizer.authorizeCreateSubmodel(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId);
    }

    @Override
    public void createSubmodel(ISubmodelAPI submodelAPI) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAggregator.createSubmodel(submodelAPI);
            return;
        }
        try {
            this.authorizeCreateSubmodel(submodelAPI);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedSubmodelAggregator.createSubmodel(submodelAPI);
    }

    protected void authorizeCreateSubmodel(ISubmodelAPI submodelAPI) throws InhibitException {
        IIdentifier smId = Optional.ofNullable(submodelAPI).map(ISubmodelAPI::getSubmodel).map(IIdentifiable::getIdentification).orElse(null);
        ISubmodel sm = this.getSmUnsecured(smId);
        IReference smSemanticId = this.getSmSemanticIdUnsecured(sm);
        this.submodelAggregatorAuthorizer.authorizeCreateSubmodel(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId);
    }

    @Override
    public void updateSubmodel(Submodel submodel) throws ResourceNotFoundException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAggregator.updateSubmodel(submodel);
            return;
        }
        IIdentifier smId = Optional.ofNullable(submodel).map(Submodel::getIdentification).orElse(null);
        try {
            this.authorizeUpdateSubmodel(smId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedSubmodelAggregator.updateSubmodel(submodel);
    }

    protected void authorizeUpdateSubmodel(IIdentifier smId) throws InhibitException {
        ISubmodel sm = this.getSmUnsecured(smId);
        IReference smSemanticId = this.getSmSemanticIdUnsecured(sm);
        this.submodelAggregatorAuthorizer.authorizeUpdateSubmodel(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId);
    }

    @Override
    public void deleteSubmodelByIdentifier(IIdentifier identifier) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAggregator.deleteSubmodelByIdentifier(identifier);
            return;
        }
        try {
            this.authorizeDeleteSubmodelByIdentifier(identifier);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedSubmodelAggregator.deleteSubmodelByIdentifier(identifier);
    }

    protected void authorizeDeleteSubmodelByIdentifier(IIdentifier smId) throws InhibitException {
        ISubmodel sm = this.getSmUnsecured(smId);
        IReference smSemanticId = this.getSmSemanticIdUnsecured(sm);
        this.submodelAggregatorAuthorizer.authorizeDeleteSubmodelByIdentifier(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId);
    }

    @Override
    public void deleteSubmodelByIdShort(String smIdShortPath) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAggregator.deleteSubmodelByIdShort(smIdShortPath);
            return;
        }
        try {
            this.authorizeDeleteSubmodelByIdShort(smIdShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedSubmodelAggregator.deleteSubmodelByIdShort(smIdShortPath);
    }

    protected void authorizeDeleteSubmodelByIdShort(String smIdShortPath) throws InhibitException {
        ISubmodel sm = this.getSmUnsecured(smIdShortPath);
        IIdentifier smId = this.getSmIdUnsecured(sm);
        IReference smSemanticId = this.getSmSemanticIdUnsecured(sm);
        this.submodelAggregatorAuthorizer.authorizeDeleteSubmodelByIdentifier(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId);
    }

    private ISubmodel getSmUnsecured(IIdentifier smId) throws ResourceNotFoundException {
        try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
            ISubmodel iSubmodel = this.decoratedSubmodelAggregator.getSubmodel(smId);
            return iSubmodel;
        }
    }

    private ISubmodel getSmUnsecured(String smIdShortPath) throws ResourceNotFoundException {
        try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
            ISubmodel iSubmodel = this.decoratedSubmodelAggregator.getSubmodelbyIdShort(smIdShortPath);
            return iSubmodel;
        }
    }

    private IIdentifier getSmIdUnsecured(ISubmodel sm) throws ResourceNotFoundException {
        if (sm == null) {
            return null;
        }
        try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
            IIdentifier iIdentifier = sm.getIdentification();
            return iIdentifier;
        }
    }

    private IReference getSmSemanticIdUnsecured(ISubmodel sm) throws ResourceNotFoundException {
        if (sm == null) {
            return null;
        }
        try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
            IReference iReference = sm.getSemanticId();
            return iReference;
        }
    }
}

