/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.facade;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.exception.IdShortDuplicationException;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.Entity;

public class SubmodelElementMapCollectionConverter {
    public static Submodel mapToSM(Map<String, Object> submodel) {
        Submodel ret = new Submodel();
        ret.setMap(submodel);
        Object smElements = submodel.get("submodelElements");
        ret.put("submodelElements", SubmodelElementMapCollectionConverter.convertCollectionToIDMap(smElements));
        return ret;
    }

    public static Map<String, Object> smToMap(Submodel submodel) {
        Map<String, ISubmodelElement> smElements = submodel.getSubmodelElements();
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.putAll(submodel);
        List newElements = smElements.values().stream().map(e -> SubmodelElementMapCollectionConverter.smElementToMap((Map)((Object)e))).collect(Collectors.toList());
        ret.put("submodelElements", newElements);
        return ret;
    }

    public static SubmodelElementCollection mapToSmECollection(Map<String, Object> smECollection) {
        SubmodelElementCollection ret = new SubmodelElementCollection();
        ret.setMap(smECollection);
        Object smElements = smECollection.get("value");
        ret.put("value", SubmodelElementMapCollectionConverter.convertCollectionToIDMap(smElements));
        return ret;
    }

    public static Map<String, Object> smElementToMap(Map<String, Object> smElement) {
        if (SubmodelElementCollection.isSubmodelElementCollection(smElement)) {
            return SubmodelElementMapCollectionConverter.convertSMC(smElement);
        }
        if (Entity.isEntity(smElement)) {
            return SubmodelElementMapCollectionConverter.convertEntity(smElement);
        }
        return smElement;
    }

    private static Map<String, Object> convertEntity(Map<String, Object> smElement) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.putAll(smElement);
        Collection statements = (Collection)smElement.get("statements");
        Collection<Map<String, Object>> convertedStatements = SubmodelElementMapCollectionConverter.convertStatementList(statements);
        ret.put("statements", convertedStatements);
        return ret;
    }

    private static Collection<Map<String, Object>> convertStatementList(Collection<Map<String, Object>> statements) {
        return statements.stream().map(SubmodelElementMapCollectionConverter::smElementToMap).collect(Collectors.toList());
    }

    private static Map<String, Object> convertSMC(Map<String, Object> smElement) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.putAll(smElement);
        ret.put("value", SubmodelElementMapCollectionConverter.convertIDMapToCollection(smElement.get("value")));
        return ret;
    }

    public static Map<String, Object> convertCollectionToIDMap(Object smElements) {
        Map<String, Object> smElementsMap = new LinkedHashMap<String, Object>();
        if (smElements == null) {
            return smElementsMap;
        }
        if (smElements instanceof Collection) {
            Collection smElementsSet = (Collection)smElements;
            for (Object o : smElementsSet) {
                Map smElement2 = (Map)o;
                String id2 = (String)smElement2.get("idShort");
                if (smElementsMap.containsKey(id2)) {
                    throw new IdShortDuplicationException(smElementsMap);
                }
                smElementsMap.put(id2, smElement2);
            }
        } else if (smElements instanceof Map) {
            if (SubmodelElementMapCollectionConverter.isDuplicateIdShortPresentInSubmodelElements((Map)smElements)) {
                throw new IdShortDuplicationException(smElementsMap);
            }
            smElementsMap = (Map)smElements;
        } else {
            throw new RuntimeException("Elements must be given as Map or Collection");
        }
        smElementsMap.replaceAll((id, smElement) -> SubmodelElementFacadeFactory.createSubmodelElement((Map)smElement));
        return smElementsMap;
    }

    private static boolean isDuplicateIdShortPresentInSubmodelElements(Map<String, Object> submodelElements) {
        LinkedHashMap<String, Object> helperMap = new LinkedHashMap<String, Object>();
        for (String key : submodelElements.keySet()) {
            Map submodelElement = (Map)submodelElements.get(key);
            if (helperMap.containsKey(submodelElement.get("idShort"))) {
                return true;
            }
            helperMap.put(key, submodelElements.get(key));
        }
        return false;
    }

    public static Collection<Map<String, Object>> convertIDMapToCollection(Object map) {
        Collection smElements = null;
        if (map instanceof Collection) {
            smElements = (Collection)map;
        } else if (map instanceof Map) {
            smElements = ((Map)map).values();
        } else {
            throw new RuntimeException("The SubmodelElementCollection contains neither a Collection nor a Map as value.");
        }
        List<Map<String, Object>> newElements = smElements.stream().map(e -> SubmodelElementMapCollectionConverter.smElementToMap((Map)e)).collect(Collectors.toList());
        return newElements;
    }
}

