/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi.vab;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.restapi.MultiSubmodelElementProvider;
import org.eclipse.basyx.submodel.restapi.SubmodelAPIHelper;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class VABSubmodelAPI
implements ISubmodelAPI {
    private IModelProvider modelProvider;
    private String tmpDirectory = Files.createTempDir().getAbsolutePath();

    public VABSubmodelAPI(IModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    private MultiSubmodelElementProvider getElementProvider() {
        VABElementProxy elementProxy = new VABElementProxy(SubmodelAPIHelper.getSubmodelElementsPath(), this.modelProvider);
        return new MultiSubmodelElementProvider(elementProxy);
    }

    @Override
    public Submodel getSubmodel() {
        Map map = (Map)this.modelProvider.getValue(SubmodelAPIHelper.getSubmodelPath());
        LinkedHashMap<String, Object> smCopy = new LinkedHashMap<String, Object>();
        smCopy.putAll(map);
        return Submodel.createAsFacade(smCopy);
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        this.getElementProvider().createValue(SubmodelAPIHelper.getSubmodelElementPath(elem.getIdShort()), elem);
    }

    @Override
    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        this.getElementProvider().createValue(SubmodelAPIHelper.getSubmodelElementPath(idShortPath), elem);
    }

    @Override
    public void deleteSubmodelElement(String idShortPath) {
        ISubmodelElement submodelElement = this.getSubmodelElement(idShortPath);
        if (org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File.isFile((Map)((Object)submodelElement))) {
            org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File file = org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File.createAsFacade((Map)((Object)submodelElement));
            File tmpFile = new File(file.getValue());
            tmpFile.delete();
        }
        this.getElementProvider().deleteValue(SubmodelAPIHelper.getSubmodelElementPath(idShortPath));
    }

    @Override
    public Collection<IOperation> getOperations() {
        return this.getSubmodelElements().stream().filter(e -> e instanceof IOperation).map(e -> (IOperation)e).collect(Collectors.toList());
    }

    @Override
    public Collection<ISubmodelElement> getSubmodelElements() {
        Collection elements = (Collection)this.getElementProvider().getValue(SubmodelAPIHelper.getSubmodelElementsPath());
        return elements.stream().map(SubmodelElement::createAsFacade).collect(Collectors.toList());
    }

    @Override
    public void updateSubmodelElement(String idShortPath, Object newValue) {
        this.getElementProvider().setValue(SubmodelAPIHelper.getSubmodelElementValuePath(idShortPath), newValue);
    }

    @Override
    public void uploadSubmodelElementFile(String idShortPath, InputStream fileStream) {
        ISubmodelElement submodelElement = this.getSubmodelElement(idShortPath);
        if (org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File.isFile((Map)((Object)submodelElement))) {
            try {
                this.createFile(idShortPath, fileStream, submodelElement);
            }
            catch (IOException e) {
                throw new ProviderException(e);
            }
        } else {
            throw new MalformedRequestException("The request is invalid for a SubmodelElement with type '" + submodelElement.getModelType() + "'");
        }
    }

    private void createFile(String idShortPath, Object newValue, ISubmodelElement submodelElement) throws IOException {
        org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File file = org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File.createAsFacade((Map)((Object)submodelElement));
        String filePath = this.getFilePath(idShortPath, file);
        File targetFile = new File(filePath);
        try (FileOutputStream outStream = new FileOutputStream(targetFile);
             InputStream inStream = (InputStream)newValue;){
            IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
        }
    }

    private String getFilePath(String idShortPath, org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File file) {
        String fileName = idShortPath.replaceAll("/", "-");
        String extension = this.getFileExtension(file);
        return this.tmpDirectory + "/" + fileName + extension;
    }

    private String getFileExtension(org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File file) {
        MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
        try {
            MimeType mimeType = allTypes.forName(file.getMimeType());
            return mimeType.getExtension();
        }
        catch (MimeTypeException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public Object getSubmodelElementValue(String idShortPath) {
        return this.getElementProvider().getValue(SubmodelAPIHelper.getSubmodelElementValuePath(idShortPath));
    }

    @Override
    public ISubmodelElement getSubmodelElement(String idShortPath) {
        return SubmodelElement.createAsFacade((Map)this.getElementProvider().getValue(SubmodelAPIHelper.getSubmodelElementPath(idShortPath)));
    }

    @Override
    public Object invokeOperation(String idShortPath, Object ... params) {
        return this.getElementProvider().invokeOperation(SubmodelAPIHelper.getSubmodelElementSyncInvokePath(idShortPath), params);
    }

    @Override
    public Object invokeAsync(String idShortPath, Object ... params) {
        return this.getElementProvider().invokeOperation(SubmodelAPIHelper.getSubmodelElementAsyncInvokePath(idShortPath), params);
    }

    @Override
    public Object getOperationResult(String idShortPath, String requestId) {
        return this.getElementProvider().getValue(SubmodelAPIHelper.getSubmodelElementResultValuePath(idShortPath, requestId));
    }

    @Override
    public File getSubmodelElementFile(String idShortPath) {
        Map submodelElement = (Map)((Object)this.getSubmodelElement(idShortPath));
        org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File fileSubmodelElement = org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File.createAsFacade(submodelElement);
        String filePath = this.getFilePath(idShortPath, fileSubmodelElement);
        return new File(filePath);
    }
}

