/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServlet;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxChildContext;
import org.eclipse.basyx.vab.protocol.http.server.JwtBearerTokenAuthenticationConfiguration;
import org.springframework.lang.Nullable;

public class BaSyxContext
extends LinkedHashMap<String, HttpServlet> {
    private static final long serialVersionUID = 1L;
    protected String contextPath;
    protected String docBasePath;
    protected String hostname;
    protected int port;
    private boolean isSecuredConnection;
    private String keyPassword;
    private String certificatePath;
    protected Map<String, Map<String, String>> servletParameter = new LinkedHashMap<String, Map<String, String>>();
    public Object AASHTTPServerResource;
    @Nullable
    private JwtBearerTokenAuthenticationConfiguration jwtBearerTokenAuthenticationConfiguration;
    private String accessControlAllowOrigin;
    private List<BaSyxChildContext> baSyxChildContext = new ArrayList<BaSyxChildContext>();

    public BaSyxContext(String reqContextPath, String reqDocBasePath) {
        this(reqContextPath, reqDocBasePath, "localhost", 8080);
    }

    public BaSyxContext(String reqContextPath, String reqDocBasePath, String hostn, int reqPort) {
        this.contextPath = reqContextPath;
        this.docBasePath = reqDocBasePath;
        this.hostname = hostn;
        this.port = reqPort;
        this.isSecuredConnection = false;
    }

    public BaSyxContext(String reqContextPath, String reqDocBasePath, String hostn, int reqPort, boolean isSecuredCon, String keyPath, String keyPass) {
        this(reqContextPath, reqDocBasePath, hostn, reqPort);
        this.isSecuredConnection = isSecuredCon;
        this.certificatePath = keyPath;
        this.keyPassword = keyPass;
    }

    public BaSyxContext addServletMapping(String key, HttpServlet servlet) {
        this.put(key, servlet);
        return this;
    }

    public BaSyxContext addServletMapping(String key, HttpServlet servlet, Map<String, String> servletParameter) {
        this.addServletMapping(key, servlet);
        this.addServletParameter(key, servletParameter);
        return this;
    }

    public BaSyxContext addServletParameter(String key, Map<String, String> parameter) {
        this.servletParameter.put(key, parameter);
        return this;
    }

    public BaSyxContext addChildContext(BaSyxChildContext childContext) {
        this.baSyxChildContext.add(childContext);
        return this;
    }

    public List<BaSyxChildContext> getChildContexts() {
        return this.baSyxChildContext;
    }

    public Map<String, String> getServletParameter(String key) {
        if (this.servletParameter.containsKey(key)) {
            return this.servletParameter.get(key);
        }
        return new LinkedHashMap<String, String>();
    }

    public int getPort() {
        return this.port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isSecuredConnectionEnabled() {
        return this.isSecuredConnection;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public Optional<JwtBearerTokenAuthenticationConfiguration> getJwtBearerTokenAuthenticationConfiguration() {
        return Optional.ofNullable(this.jwtBearerTokenAuthenticationConfiguration);
    }

    public void setJwtBearerTokenAuthenticationConfiguration(@Nullable JwtBearerTokenAuthenticationConfiguration jwtBearerTokenAuthenticationConfiguration) {
        this.jwtBearerTokenAuthenticationConfiguration = jwtBearerTokenAuthenticationConfiguration;
    }

    public String getAccessControlAllowOrigin() {
        return this.accessControlAllowOrigin;
    }

    public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        this.accessControlAllowOrigin = accessControlAllowOrigin;
    }
}

