/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.authorization.internal;

import java.util.Arrays;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedAASRegistryFeature;
import org.eclipse.basyx.components.registry.authorization.internal.CustomAuthorizedAASRegistryFeature;
import org.eclipse.basyx.components.registry.authorization.internal.GrantedAuthorityAuthorizedAASRegistryFeature;
import org.eclipse.basyx.components.registry.authorization.internal.SimpleRbacAuthorizedAASRegistryFeature;

public class AuthorizedAASRegistryFeatureFactory {
    private final BaSyxSecurityConfiguration securityConfig;

    public AuthorizedAASRegistryFeatureFactory(BaSyxSecurityConfiguration securityConfig) {
        this.securityConfig = securityConfig;
    }

    public AuthorizedAASRegistryFeature create() {
        BaSyxSecurityConfiguration.AuthorizationStrategy strategy;
        String strategyString = this.securityConfig.getAuthorizationStrategy();
        if (strategyString == null) {
            throw new IllegalArgumentException(String.format("no authorization strategy set, please set %s in security.properties", "authorization.strategy"));
        }
        try {
            strategy = BaSyxSecurityConfiguration.AuthorizationStrategy.valueOf((String)strategyString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("unknown authorization strategy %s set in security.properties, available options: %s", strategyString, Arrays.toString(BaSyxSecurityConfiguration.AuthorizationStrategy.values())));
        }
        switch (strategy) {
            case SimpleRbac: {
                return new SimpleRbacAuthorizedAASRegistryFeature(this.securityConfig);
            }
            case GrantedAuthority: {
                return new GrantedAuthorityAuthorizedAASRegistryFeature(this.securityConfig);
            }
            case Custom: {
                return new CustomAuthorizedAASRegistryFeature(this.securityConfig);
            }
        }
        throw new UnsupportedOperationException("no handler for authorization strategy " + strategyString);
    }
}

