/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.mongodb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.memory.IRegistryHandler;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.registry.mongodb.MongoDBRegistryHandler;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedSubmodelDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.map.MapTaggedDirectory;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;

public class MongoDBTaggedDirectory
extends MapTaggedDirectory {
    public MongoDBTaggedDirectory(BaSyxMongoDBConfiguration mongoDBConfig, Map<String, Set<TaggedAASDescriptor>> tagMap) {
        super((IRegistryHandler)new MongoDBRegistryHandler(mongoDBConfig), tagMap);
        this.initializeTagMap();
    }

    public MongoDBTaggedDirectory(BaSyxMongoDBConfiguration mongoDBConfig) {
        this(mongoDBConfig, new HashMap<String, Set<TaggedAASDescriptor>>());
    }

    private void initializeTagMap() {
        List shellDescriptors = this.handler.getAll();
        shellDescriptors.stream().filter(this::isTaggedDescriptor).map(TaggedAASDescriptor::createAsFacade).forEach(x$0 -> super.addTags(x$0));
    }

    private boolean isTaggedDescriptor(ModelDescriptor descriptor) {
        return descriptor.get((Object)"tags") != null;
    }

    public void registerSubmodel(IIdentifier shellIdentifier, TaggedSubmodelDescriptor descriptor) {
        super.register(shellIdentifier, (SubmodelDescriptor)descriptor);
        this.addSubmodelTags(descriptor);
        this.updateTagMap(shellIdentifier, descriptor);
    }

    private void updateTagMap(IIdentifier shellIdentifier, TaggedSubmodelDescriptor descriptor) {
        this.tagMap.values().forEach(tagSet -> tagSet.forEach(taggedDescriptor -> {
            if (this.descriptorEqualsToGivenAASId(shellIdentifier, (TaggedAASDescriptor)taggedDescriptor) && !this.containsSubmodelDescriptor(descriptor, (TaggedAASDescriptor)taggedDescriptor)) {
                taggedDescriptor.addSubmodelDescriptor((SubmodelDescriptor)descriptor);
            }
        }));
    }

    private boolean containsSubmodelDescriptor(TaggedSubmodelDescriptor descriptor, TaggedAASDescriptor tagDesc) {
        return tagDesc.getSubmodelDescriptorFromIdShort(descriptor.getIdShort()) != null;
    }

    private boolean descriptorEqualsToGivenAASId(IIdentifier shellIdentifier, TaggedAASDescriptor taggedDescriptor) {
        return taggedDescriptor.getIdentifier().getId().equals(shellIdentifier.getId());
    }
}

