/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.data.mongodb.core.spel.ExpressionTransformationContextSupport;
import org.springframework.data.mongodb.core.spel.ExpressionTransformer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

interface AggregationExpressionTransformer
extends ExpressionTransformer<AggregationExpressionTransformationContext<ExpressionNode>> {

    public static class AggregationExpressionTransformationContext<T extends ExpressionNode>
    extends ExpressionTransformationContextSupport<T> {
        private final AggregationOperationContext aggregationContext;

        public AggregationExpressionTransformationContext(T currentNode, @Nullable ExpressionNode parentNode, @Nullable Document previousOperationObject, AggregationOperationContext context) {
            super(currentNode, parentNode, previousOperationObject);
            Assert.notNull((Object)context, (String)"AggregationOperationContext must not be null!");
            this.aggregationContext = context;
        }

        public AggregationOperationContext getAggregationContext() {
            return this.aggregationContext;
        }

        public ExposedFields.FieldReference getFieldReference() {
            return this.aggregationContext.getReference(((ExpressionNode)this.getCurrentNode()).getName());
        }
    }
}

