/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import java.util.function.Function;
import org.bson.Document;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.Nullable;

public class MongoMappingEvent<T>
extends ApplicationEvent {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final Document document;
    @Nullable
    private final String collectionName;

    public MongoMappingEvent(T source, @Nullable Document document, @Nullable String collectionName) {
        super(source);
        this.document = document;
        this.collectionName = collectionName;
    }

    @Nullable
    public Document getDocument() {
        return this.document;
    }

    @Nullable
    public String getCollectionName() {
        return this.collectionName;
    }

    public T getSource() {
        return (T)super.getSource();
    }

    final void mapSource(Function<T, T> mapper) {
        if (this.source == null) {
            return;
        }
        this.source = mapper.apply(this.getSource());
    }
}

