/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.UUID;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.Transformer;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;

final class ContainerCodecHelper {
    static Object readValue(BsonReader reader, DecoderContext decoderContext, BsonTypeCodecMap bsonTypeCodecMap, UuidRepresentation uuidRepresentation, CodecRegistry registry, Transformer valueTransformer) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        Codec<Object> codec = bsonTypeCodecMap.get(bsonType);
        if (bsonType == BsonType.BINARY && reader.peekBinarySize() == 16) {
            switch (reader.peekBinarySubType()) {
                case 3: {
                    if (uuidRepresentation != UuidRepresentation.JAVA_LEGACY && uuidRepresentation != UuidRepresentation.C_SHARP_LEGACY && uuidRepresentation != UuidRepresentation.PYTHON_LEGACY) break;
                    codec = registry.get(UUID.class);
                    break;
                }
                case 4: {
                    if (uuidRepresentation != UuidRepresentation.STANDARD) break;
                    codec = registry.get(UUID.class);
                    break;
                }
            }
        }
        return valueTransformer.transform(codec.decode(reader, decoderContext));
    }

    static Codec<?> getCodec(CodecRegistry codecRegistry, Type type) {
        if (type instanceof Class) {
            return codecRegistry.get((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return codecRegistry.get((Class)parameterizedType.getRawType(), Arrays.asList(parameterizedType.getActualTypeArguments()));
        }
        throw new CodecConfigurationException("Unsupported generic type of container: " + type);
    }

    private ContainerCodecHelper() {
    }
}

