/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.json;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;

public class BidirectionalJSONConverter {
    private static GSONTools gsonTools = new GSONTools(new DefaultTypeFactory());

    public static String serializeSubmodel(ISubmodel submodel) {
        return gsonTools.serialize(submodel);
    }

    public static ISubmodel deserializeSubmodel(String jsonSubmodel) {
        return Submodel.createAsFacade((Map)gsonTools.deserialize(jsonSubmodel));
    }

    public static String serializeShell(AssetAdministrationShell shell) {
        return gsonTools.serialize(shell);
    }

    public static AssetAdministrationShell deserializeShell(String jsonShell) {
        return AssetAdministrationShell.createAsFacade((Map)gsonTools.deserialize(jsonShell));
    }

    public static <T> String serializeObject(T object) {
        return gsonTools.serialize(object);
    }

    public static <T> T deserializeJSON(String json) {
        Object retrieved = gsonTools.deserialize(json);
        return (T)retrieved;
    }

    public static AASDescriptor deserializeAASDescriptor(String json) {
        return AASDescriptor.createAsFacade((Map)gsonTools.deserialize(json));
    }

    public static String semanticIdAsSString(ISubmodel submodel) {
        if (submodel.getSemanticId() == null) {
            return null;
        }
        List<IKey> keys = submodel.getSemanticId().getKeys();
        return BidirectionalJSONConverter.semanticIdKeysToString(keys);
    }

    public static String semanticIdKeysToString(List<IKey> keys) {
        return keys.stream().map(k -> "type:" + k.getType() + ";value:" + k.getValue() + ";idType:" + k.getIdType()).collect(Collectors.joining("/"));
    }
}

