/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.api.authorization.internal;

import java.util.function.Supplier;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.extensions.aas.api.authorization.internal.IAASAPIAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.ElevatedCodeAuthentication;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.IdHelper;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.SimpleRbacHelper;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;

public class SimpleRbacAASAPIAuthorizer<SubjectInformationType>
implements IAASAPIAuthorizer<SubjectInformationType> {
    protected IRbacRuleChecker rbacRuleChecker;
    protected IRoleAuthenticator<SubjectInformationType> roleAuthenticator;

    public SimpleRbacAASAPIAuthorizer(IRbacRuleChecker rbacRuleChecker, IRoleAuthenticator<SubjectInformationType> roleAuthenticator) {
        this.rbacRuleChecker = rbacRuleChecker;
        this.roleAuthenticator = roleAuthenticator;
    }

    @Override
    public IAssetAdministrationShell authorizeGetAAS(SubjectInformationType subjectInformation, Supplier<IAssetAdministrationShell> aasSupplier) throws InhibitException {
        IIdentifier aasId = this.getAasId(aasSupplier);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-api:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null, null));
        return aasSupplier.get();
    }

    @Override
    public void authorizeAddSubmodel(SubjectInformationType subjectInformation, Supplier<IAssetAdministrationShell> aasSupplier, IReference smId) throws InhibitException {
        IIdentifier aasId = this.getAasId(aasSupplier);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-api:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getReferenceId(smId), null, null));
    }

    @Override
    public void authorizeRemoveSubmodel(SubjectInformationType subjectInformation, Supplier<IAssetAdministrationShell> aasSupplier, String smIdShortPath) throws InhibitException {
        IIdentifier aasId = this.getAasId(aasSupplier);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-api:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), smIdShortPath, null, null));
    }

    private IIdentifier getAasId(Supplier<IAssetAdministrationShell> aasSupplier) {
        try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
            IAssetAdministrationShell aas = aasSupplier.get();
            if (aas == null) {
                IIdentifier iIdentifier = null;
                return iIdentifier;
            }
            IIdentifier iIdentifier = aas.getIdentification();
            return iIdentifier;
        }
    }
}

