/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.authorization.internal;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.extensions.shared.authorization.internal.ElevatedCodeAuthentication;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.extensions.submodel.authorization.internal.ISubmodelAPIAuthorizer;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedSubmodelAPI<SubjectInformationType>
implements ISubmodelAPI {
    private static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:sm-api:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:sm-api:write";
    public static final String EXECUTE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:sm-api:execute";
    private static final Logger logger = LoggerFactory.getLogger(AuthorizedSubmodelAPI.class);
    protected final IAssetAdministrationShell aas;
    protected final ISubmodelAPI decoratedSubmodelAPI;
    protected final ISubmodelAPIAuthorizer<SubjectInformationType> submodelAPIAuthorizer;
    protected final ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider;

    public AuthorizedSubmodelAPI(ISubmodelAPI decoratedSubmodelAPI, ISubmodelAPIAuthorizer<SubjectInformationType> submodelAPIAuthorizer, ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider) {
        this(null, decoratedSubmodelAPI, submodelAPIAuthorizer, subjectInformationProvider);
    }

    public AuthorizedSubmodelAPI(IAssetAdministrationShell aas, ISubmodelAPI decoratedSubmodelAPI, ISubmodelAPIAuthorizer<SubjectInformationType> submodelAPIAuthorizer, ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider) {
        this.aas = aas;
        this.decoratedSubmodelAPI = decoratedSubmodelAPI;
        this.submodelAPIAuthorizer = submodelAPIAuthorizer;
        this.subjectInformationProvider = subjectInformationProvider;
    }

    @Override
    public ISubmodel getSubmodel() {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAPI.getSubmodel();
        }
        try {
            return this.authorizeGetSubmodel();
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected ISubmodel authorizeGetSubmodel() throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        return this.submodelAPIAuthorizer.authorizeGetSubmodel(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, this.decoratedSubmodelAPI::getSubmodel);
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAPI.addSubmodelElement(elem);
            return;
        }
        try {
            this.authorizeAddSubmodelElement(elem.getIdShort());
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedSubmodelAPI.addSubmodelElement(elem);
    }

    @Override
    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAPI.addSubmodelElement(idShortPath, elem);
            return;
        }
        try {
            this.authorizeAddSubmodelElement(idShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedSubmodelAPI.addSubmodelElement(idShortPath, elem);
    }

    protected void authorizeAddSubmodelElement(String smElIdShortPath) throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        this.submodelAPIAuthorizer.authorizeAddSubmodelElement(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, smElIdShortPath);
    }

    @Override
    public ISubmodelElement getSubmodelElement(String idShortPath) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAPI.getSubmodelElement(idShortPath);
        }
        try {
            return this.authorizeGetSubmodelElement(idShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected ISubmodelElement authorizeGetSubmodelElement(String smElIdShortPath) throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        return this.submodelAPIAuthorizer.authorizeGetSubmodelElement(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, smElIdShortPath, () -> this.decoratedSubmodelAPI.getSubmodelElement(smElIdShortPath));
    }

    @Override
    public void deleteSubmodelElement(String idShortPath) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAPI.deleteSubmodelElement(idShortPath);
            return;
        }
        try {
            this.authorizeDeleteSubmodelElement(idShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedSubmodelAPI.deleteSubmodelElement(idShortPath);
    }

    protected void authorizeDeleteSubmodelElement(String smElIdShortPath) throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        this.submodelAPIAuthorizer.authorizeDeleteSubmodelElement(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, smElIdShortPath);
    }

    @Override
    public Collection<IOperation> getOperations() {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAPI.getOperations();
        }
        try {
            return this.authorizeGetOperations();
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Collection<IOperation> authorizeGetOperations() throws InhibitException {
        return this.getOperationListOnly().stream().map(operation -> {
            try {
                return (IOperation)this.authorizeGetSubmodelElement(operation.getIdShort());
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Collection<IOperation> getOperationListOnly() throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        return this.submodelAPIAuthorizer.authorizeGetOperations(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, this.decoratedSubmodelAPI::getSubmodel, this.decoratedSubmodelAPI::getOperations);
    }

    @Override
    public Collection<ISubmodelElement> getSubmodelElements() {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAPI.getSubmodelElements();
        }
        try {
            return this.authorizeGetSubmodelElements();
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Collection<ISubmodelElement> authorizeGetSubmodelElements() throws InhibitException {
        return this.getSubmodelElementListOnly().stream().map(smEl -> {
            try {
                return this.authorizeGetSubmodelElement(smEl.getIdShort());
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Collection<ISubmodelElement> getSubmodelElementListOnly() throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        return this.submodelAPIAuthorizer.authorizeGetSubmodelElements(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, this.decoratedSubmodelAPI::getSubmodel, this.decoratedSubmodelAPI::getSubmodelElements);
    }

    @Override
    public void updateSubmodelElement(String idShortPath, Object newValue) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAPI.updateSubmodelElement(idShortPath, newValue);
            return;
        }
        try {
            this.authorizeUpdateSubmodelElement(idShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedSubmodelAPI.updateSubmodelElement(idShortPath, newValue);
    }

    protected void authorizeUpdateSubmodelElement(String smElIdShortPath) throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        this.submodelAPIAuthorizer.authorizeUpdateSubmodelElement(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, smElIdShortPath);
    }

    @Override
    public Object getSubmodelElementValue(String idShortPath) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAPI.getSubmodelElementValue(idShortPath);
        }
        try {
            return this.authorizeGetSubmodelElementValue(idShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Object authorizeGetSubmodelElementValue(String smElIdShortPath) throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        return this.submodelAPIAuthorizer.authorizeGetSubmodelElementValue(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, smElIdShortPath, () -> this.decoratedSubmodelAPI.getSubmodelElementValue(smElIdShortPath));
    }

    @Override
    public Object invokeOperation(String inputIdShortPath, Object ... params) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAPI.invokeOperation(inputIdShortPath, params);
        }
        String idShortPath = this.fixInvokeIdShortPath(inputIdShortPath);
        try {
            this.authorizeInvokeOperation(idShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        return this.decoratedSubmodelAPI.invokeOperation(idShortPath, params);
    }

    @Override
    public Object invokeAsync(String idShortPath, Object ... params) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAPI.invokeAsync(idShortPath, params);
        }
        try {
            this.authorizeInvokeOperation(idShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        return this.decoratedSubmodelAPI.invokeAsync(idShortPath, params);
    }

    protected String fixInvokeIdShortPath(String inputIdShortPath) {
        return inputIdShortPath.replaceFirst("/invoke$", "");
    }

    protected void authorizeInvokeOperation(String smElIdShortPath) throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        this.submodelAPIAuthorizer.authorizeInvokeOperation(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, smElIdShortPath);
    }

    @Override
    public Object getOperationResult(String smElIdShortPath, String requestId) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAPI.getOperationResult(smElIdShortPath, requestId);
        }
        try {
            return this.authorizeGetOperationResult(smElIdShortPath, requestId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Object authorizeGetOperationResult(String smElIdShortPath, String requestId) throws InhibitException {
        IIdentifier smId = this.getSmIdUnsecured();
        IReference smSemanticId = this.getSmSemanticIdUnsecured();
        return this.submodelAPIAuthorizer.authorizeGetOperationResult(this.subjectInformationProvider.get(), this.aas, smId, smSemanticId, smElIdShortPath, requestId, () -> this.decoratedSubmodelAPI.getOperationResult(smElIdShortPath, requestId));
    }

    @Override
    public File getSubmodelElementFile(String idShortPath) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedSubmodelAPI.getSubmodelElementFile(idShortPath);
        }
        try {
            this.authorizeGetSubmodelElement(idShortPath);
            return this.decoratedSubmodelAPI.getSubmodelElementFile(idShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    @Override
    public void uploadSubmodelElementFile(String idShortPath, InputStream fileStream) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedSubmodelAPI.uploadSubmodelElementFile(idShortPath, fileStream);
            return;
        }
        try {
            this.authorizeUpdateSubmodelElement(idShortPath);
            this.decoratedSubmodelAPI.uploadSubmodelElementFile(idShortPath, fileStream);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    private IIdentifier getSmIdUnsecured() throws ResourceNotFoundException {
        ISubmodel sm = this.decoratedSubmodelAPI.getSubmodel();
        if (sm == null) {
            return null;
        }
        return sm.getIdentification();
    }

    private IReference getSmSemanticIdUnsecured() {
        try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
            ISubmodel sm = this.decoratedSubmodelAPI.getSubmodel();
            if (sm == null) {
                IReference iReference = null;
                return iReference;
            }
            IReference iReference = sm.getSemanticId();
            return iReference;
        }
    }
}

