/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement;

import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement;

public class MultiLanguageProperty
extends DataElement
implements IMultiLanguageProperty {
    public static final String MODELTYPE = "MultiLanguageProperty";
    public static final String VALUE = "value";
    public static final String VALUEID = "valueId";

    public MultiLanguageProperty() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public MultiLanguageProperty(String idShort) {
        super(idShort);
        this.putAll(new ModelType(MODELTYPE));
    }

    public MultiLanguageProperty(Reference reference, LangStrings langStrings) {
        this();
        this.put(VALUE, langStrings);
        this.put(VALUEID, reference);
    }

    public static MultiLanguageProperty createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!MultiLanguageProperty.isValid(obj)) {
            throw new MetamodelConstructionException(MultiLanguageProperty.class, obj);
        }
        MultiLanguageProperty facade = new MultiLanguageProperty();
        facade.setMap(obj);
        return facade;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return DataElement.isValid(obj);
    }

    public static boolean isMultiLanguageProperty(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey(VALUE) && map.containsKey(VALUE) && map.containsKey(VALUEID) && !map.containsKey("valueType");
    }

    @Override
    public IReference getValueId() {
        return Reference.createAsFacade((Map)this.get(VALUEID));
    }

    @Override
    public LangStrings getValue() {
        return LangStrings.createAsFacade((Collection)this.get(VALUE));
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.MULTILANGUAGEPROPERTY;
    }

    @Override
    public void setValue(Object value) {
        if (!LangStrings.isLangStrings(value)) {
            throw new IllegalArgumentException("Given Object is not a LangStrings");
        }
        LangStrings strings = LangStrings.createAsFacade((Collection)value);
        this.setValue(strings);
    }

    @Override
    public MultiLanguageProperty getLocalCopy() {
        MultiLanguageProperty copy = new MultiLanguageProperty();
        copy.putAll(this);
        return copy;
    }

    @Override
    public void setValue(LangStrings value) {
        this.put(VALUE, value);
    }
}

