/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi;

import java.io.FileInputStream;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.restapi.OperationProvider;
import org.eclipse.basyx.submodel.restapi.PropertyProvider;
import org.eclipse.basyx.submodel.restapi.SubmodelElementCollectionProvider;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class SubmodelElementProvider
implements IModelProvider {
    private IModelProvider proxy;
    private boolean specializedProvider = false;

    public SubmodelElementProvider(IModelProvider proxy) {
        IModelProvider unchangedProxy = proxy;
        this.proxy = SubmodelElementProvider.getElementProvider(proxy);
        this.specializedProvider = unchangedProxy != this.proxy;
    }

    public static IModelProvider getElementProvider(IModelProvider proxy) {
        Map elementMap = (Map)proxy.getValue("");
        if (Operation.isOperation(elementMap)) {
            return new OperationProvider(proxy);
        }
        if (SubmodelElementCollection.isSubmodelElementCollection(elementMap)) {
            return new SubmodelElementCollectionProvider(proxy);
        }
        if (Property.isProperty(elementMap)) {
            return new PropertyProvider(proxy);
        }
        return proxy;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        if ((path = VABPathTools.stripSlashes(path)).equals("value")) {
            if (this.specializedProvider) {
                return this.proxy.getValue(path);
            }
            Map elementMap = (Map)this.proxy.getValue("");
            ISubmodelElement element = SubmodelElementFacadeFactory.createSubmodelElement(elementMap);
            try {
                return element.getValue();
            }
            catch (UnsupportedOperationException e) {
                throw new MalformedRequestException("The requested Element '" + element.getIdShort() + "' has no value.");
            }
        }
        return this.proxy.getValue(path);
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        if (!(path = VABPathTools.stripSlashes(path)).endsWith("value")) {
            throw new MalformedRequestException("The given path '" + path + "' does not end in /value.");
        }
        if (!this.specializedProvider && path.equals("value") && !this.isFileInputStream(newValue)) {
            Map elementMap = (Map)this.proxy.getValue("");
            ISubmodelElement element = SubmodelElementFacadeFactory.createSubmodelElement(elementMap);
            try {
                element.setValue(newValue);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedRequestException("The given Value was not valid for Element '" + path + "'");
            }
            this.proxy.setValue("", element);
        } else {
            this.proxy.setValue(path, newValue);
        }
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        if (!this.specializedProvider) {
            throw new MalformedRequestException("Creating a new Element is not allowed at '" + path + "'");
        }
        this.proxy.createValue(path, newEntity);
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        if (!this.specializedProvider) {
            throw new MalformedRequestException("Deleting the Element '" + path + "' is not allowed");
        }
        this.proxy.deleteValue(path);
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete with a passed argument not allowed");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        return this.proxy.invokeOperation(path, parameter);
    }

    private boolean isFileInputStream(Object newValue) {
        return newValue instanceof FileInputStream;
    }
}

