/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.technicaldata.submodelelementcollections.productclassifications;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;

public class ProductClassificationItem
extends SubmodelElementCollection {
    public static final String PRODUCTCLASSIFICATIONSYSTEMID = "ProductClassificationSystem";
    public static final String CLASSIFICATIONSYSTEMVERSIONID = "ClassificationSystemVersion";
    public static final String PRODUCTCLASSID = "ProductClassId";
    public static final Reference SEMANTICID = new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/ProductClassificationItem/1/1", KeyType.IRI));

    private ProductClassificationItem() {
    }

    public ProductClassificationItem(String idShort, Property productClassificationSystem, Property productClassId) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setProductClassificationSystem(productClassificationSystem);
        this.setProductClassId(productClassId);
    }

    public ProductClassificationItem(String idShort, String productClassificationSystem, String productClassId) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setProductClassificationSystem(productClassificationSystem);
        this.setProductClassId(productClassId);
    }

    public static ProductClassificationItem createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!ProductClassificationItem.isValid(obj)) {
            throw new MetamodelConstructionException(ProductClassificationItem.class, obj);
        }
        ProductClassificationItem productClassificationItem = new ProductClassificationItem();
        productClassificationItem.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return productClassificationItem;
    }

    private static ProductClassificationItem createAsFacadeNonStrict(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        ProductClassificationItem productClassificationItem = new ProductClassificationItem();
        productClassificationItem.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return productClassificationItem;
    }

    public static boolean isValid(Map<String, Object> obj) {
        ProductClassificationItem productClassificationItem = ProductClassificationItem.createAsFacadeNonStrict(obj);
        return SubmodelElementCollection.isValid(obj) && Property.isValid((Map)((Object)productClassificationItem.getProductClassificationSystem())) && Property.isValid((Map)((Object)productClassificationItem.getProductClassId()));
    }

    public void setProductClassificationSystem(Property system) {
        this.addSubmodelElement(system);
    }

    public void setProductClassificationSystem(String system) {
        Property productClassificationSystemProp = new Property(PRODUCTCLASSIFICATIONSYSTEMID, ValueType.String);
        productClassificationSystemProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/ProductClassificationSystem/1/1", IdentifierType.IRI)));
        productClassificationSystemProp.setValue(system);
        this.setProductClassificationSystem(productClassificationSystemProp);
    }

    public IProperty getProductClassificationSystem() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(PRODUCTCLASSIFICATIONSYSTEMID)));
    }

    public void setClassificationSystemVersion(Property version) {
        this.addSubmodelElement(version);
    }

    public void setClassificationSystemVersion(String version) {
        Property versionProp = new Property(CLASSIFICATIONSYSTEMVERSIONID, ValueType.String);
        versionProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/ClassificationSystemVersion/1/1", IdentifierType.IRI)));
        versionProp.setValue(version);
        this.setClassificationSystemVersion(versionProp);
    }

    public IProperty getClassificationSystemVersion() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(CLASSIFICATIONSYSTEMVERSIONID)));
    }

    public void setProductClassId(Property id) {
        this.addSubmodelElement(id);
    }

    public void setProductClassId(String id) {
        Property idProp = new Property(PRODUCTCLASSID, ValueType.String);
        idProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/ProductClassId/1/1", IdentifierType.IRI)));
        idProp.setValue(id);
        this.setProductClassId(idProp);
    }

    public IProperty getProductClassId() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(PRODUCTCLASSID)));
    }
}

