/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.connector;

import com.google.gson.Gson;
import io.netty.handler.codec.http.HttpMethod;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.basyx.vab.coder.json.metaprotocol.Message;
import org.eclipse.basyx.vab.coder.json.metaprotocol.MessageType;
import org.eclipse.basyx.vab.coder.json.metaprotocol.Result;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.protocol.api.IBaSyxConnector;
import org.eclipse.basyx.vab.protocol.http.connector.IAuthorizationSupplier;
import org.eclipse.basyx.vab.protocol.http.server.ExceptionToHTTPCodeMapper;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class HTTPConnector
implements IBaSyxConnector {
    private static Logger logger = LoggerFactory.getLogger(HTTPConnector.class);
    private String address;
    private String mediaType;
    @Nullable
    private final IAuthorizationSupplier authorizationSupplier;
    protected Client client;

    @Override
    public String getValue(String servicePath) {
        return this.httpGet(servicePath);
    }

    public HTTPConnector(String address) {
        this(address, "application/json;charset=UTF-8");
    }

    public HTTPConnector(String address, IAuthorizationSupplier authorizationSupplier) {
        this(address, "application/json;charset=UTF-8", authorizationSupplier);
    }

    public HTTPConnector(String address, String mediaType) {
        this(address, mediaType, null);
    }

    public HTTPConnector(String address, String mediaType, @Nullable IAuthorizationSupplier authorizationSupplier) {
        this.address = address;
        this.mediaType = mediaType;
        this.authorizationSupplier = authorizationSupplier;
        this.client = new JerseyClientBuilder().build();
        logger.trace("Create with addr: {}", (Object)address);
    }

    @Override
    public String setValue(String servicePath, String newValue) throws ProviderException {
        return this.httpPut(servicePath, newValue);
    }

    @Override
    public String deleteValue(String servicePath, String obj) throws ProviderException {
        return this.httpPatch(servicePath, obj);
    }

    @Override
    public String createValue(String servicePath, String newValue) throws ProviderException {
        return this.httpPost(servicePath, newValue);
    }

    @Override
    public String deleteValue(String servicePath) throws ProviderException {
        return this.httpDelete(servicePath);
    }

    protected Invocation.Builder buildRequest(Client client, String wsURL) {
        WebTarget resource = client.target(wsURL);
        Invocation.Builder request = resource.request();
        request.accept(new String[]{this.mediaType});
        this.getAuthorization().ifPresent(authorization -> request.header("Authorization", authorization));
        return request;
    }

    private Optional<String> getAuthorization() {
        return Optional.ofNullable(this.authorizationSupplier).flatMap(IAuthorizationSupplier::getAuthorization);
    }

    protected String createWSPath(String part1, String part2) {
        if (part1 == null) {
            return part2;
        }
        if (part2 == null) {
            return part1;
        }
        if (part1.endsWith("/")) {
            return part1 + part2;
        }
        return part1 + "/" + part2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpGet(String servicePath) throws ProviderException {
        logger.trace("[HTTP Get] {}", (Object)VABPathTools.concatenatePaths(this.address, servicePath));
        Invocation.Builder request = this.retrieveBuilder(servicePath);
        Response rsp = null;
        try {
            rsp = request.get();
        }
        finally {
            if (!this.isRequestSuccess(rsp)) {
                throw this.handleProcessingException(HttpMethod.GET, rsp);
            }
        }
        return (String)rsp.readEntity(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpPut(String servicePath, String newValue) throws ProviderException {
        logger.trace("[HTTP Put] {} [[ {} ]]", (Object)VABPathTools.concatenatePaths(this.address, servicePath), (Object)newValue);
        Invocation.Builder request = this.retrieveBuilder(servicePath);
        Response rsp = null;
        try {
            rsp = request.put(Entity.entity((Object)newValue, (String)this.mediaType));
        }
        finally {
            if (!this.isRequestSuccess(rsp)) {
                throw this.handleProcessingException(HttpMethod.PUT, rsp);
            }
        }
        return (String)rsp.readEntity(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String httpPatch(String servicePath, String newValue) throws ProviderException {
        logger.trace("[HTTP Patch] {} {}", (Object)VABPathTools.concatenatePaths(this.address, servicePath), (Object)newValue);
        Response rsp = null;
        try {
            Invocation.Builder request = this.client.target(VABPathTools.concatenatePaths(this.address, servicePath)).request();
            this.getAuthorization().ifPresent(authorization -> request.header("Authorization", authorization));
            rsp = request.build("PATCH", Entity.text((Object)newValue)).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true).invoke();
            if (this.isRequestSuccess(rsp)) return (String)rsp.readEntity(String.class);
        }
        catch (Throwable throwable) {
            if (this.isRequestSuccess(rsp)) throw throwable;
            throw this.handleProcessingException(HttpMethod.PATCH, rsp);
        }
        throw this.handleProcessingException(HttpMethod.PATCH, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpPost(String servicePath, String parameter) throws ProviderException {
        logger.trace("[HTTP Post] {} {}", (Object)VABPathTools.concatenatePaths(this.address, servicePath), (Object)parameter);
        Invocation.Builder request = this.retrieveBuilder(servicePath);
        Response rsp = null;
        try {
            rsp = request.post(Entity.entity((Object)parameter, (String)this.mediaType));
        }
        finally {
            if (!this.isRequestSuccess(rsp)) {
                throw this.handleProcessingException(HttpMethod.POST, rsp);
            }
        }
        return (String)rsp.readEntity(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpDelete(String servicePath) throws ProviderException {
        logger.trace("[HTTP Delete] {}", (Object)VABPathTools.concatenatePaths(this.address, servicePath));
        Invocation.Builder request = this.retrieveBuilder(servicePath);
        Response rsp = null;
        try {
            rsp = request.delete();
        }
        finally {
            if (!this.isRequestSuccess(rsp)) {
                throw this.handleProcessingException(HttpMethod.DELETE, rsp);
            }
        }
        return (String)rsp.readEntity(String.class);
    }

    @Override
    public String invokeOperation(String path, String parameter) throws ProviderException {
        return this.httpPost(path, parameter);
    }

    private Invocation.Builder retrieveBuilder(String servicePath) {
        return this.buildRequest(this.client, VABPathTools.concatenatePaths(this.address, servicePath));
    }

    private ProviderException handleProcessingException(HttpMethod method, Response rsp) {
        if (rsp == null) {
            return ExceptionToHTTPCodeMapper.mapToException(404, this.buildMessageString(method.name(), null));
        }
        int statusCode = this.getStatusCode(rsp);
        String responseJson = (String)rsp.readEntity(String.class);
        Result result = this.buildResultFromJSON(responseJson);
        List<Message> messages = result.getMessages();
        messages.add(new Message(MessageType.Exception, this.buildMessageString(method.name(), result)));
        ProviderException e = ExceptionToHTTPCodeMapper.mapToException(statusCode, result.getMessages());
        return e;
    }

    private int getStatusCode(Response rsp) {
        return rsp != null ? rsp.getStatus() : 0;
    }

    private boolean isRequestSuccess(Response rsp) {
        return rsp != null && rsp.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL;
    }

    @Override
    public String getEndpointRepresentation(String path) {
        return VABPathTools.concatenatePaths(this.address, path);
    }

    private Result buildResultFromJSON(String json) {
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(json, Map.class);
        return Result.createAsFacade(map);
    }

    private String buildMessageString(String methodName, Result result) {
        String message = "[HTTP " + methodName + "] Failed to request " + this.address + " with mediatype " + this.mediaType;
        if (result == null) {
            return message;
        }
        String text = "";
        if (result.getMessages().size() > 0) {
            text = result.getMessages().get(0).getText();
        }
        if (!text.isEmpty()) {
            message = message + ". \"" + text + "\"";
        }
        return message;
    }
}

