/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.internal.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.result.DeleteResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.internal.mongodb.MongoDBFileHelper;
import org.eclipse.basyx.extensions.internal.storage.BaSyxStorageAPI;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDBBaSyxStorageAPI<T>
extends BaSyxStorageAPI<T> {
    private final String INDEX_KEY = "identification.id";
    protected BaSyxMongoDBConfiguration config;
    protected MongoClient client;
    protected MongoOperations mongoOps;

    @Deprecated
    public MongoDBBaSyxStorageAPI(String collectionName, Class<T> type, BaSyxMongoDBConfiguration config) {
        this(collectionName, type, config, MongoClients.create((String)config.getConnectionUrl()));
    }

    public MongoDBBaSyxStorageAPI(String collectionName, Class<T> type, BaSyxMongoDBConfiguration config, MongoClient client) {
        super(collectionName, type);
        this.config = config;
        this.client = client;
        this.mongoOps = new MongoTemplate(client, config.getDatabase());
    }

    public T createOrUpdate(T obj) {
        String key = this.getKey(obj);
        if (this.alreadyExists(key)) {
            return this.update(obj, key);
        }
        Object created = this.mongoOps.insert(obj, this.getCollectionName());
        return (T)this.handleMongoDbIdAttribute(created);
    }

    private boolean alreadyExists(String key) {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)"identification.id").is((Object)key));
        return this.mongoOps.exists(hasId, this.getCollectionName());
    }

    public T update(T obj, String key) {
        T replaced = this.findAndReplaceIfExists(obj, key);
        if (replaced == null) {
            this.logger.warn("Could not execute update for key {} as it does not exist in the database; Creating new entry...", (Object)key);
            return this.createOrUpdate(obj);
        }
        replaced = this.handleMongoDbIdAttribute(replaced);
        return replaced;
    }

    private T findAndReplaceIfExists(T obj, String key) {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)"identification.id").is((Object)key));
        FindAndReplaceOptions replacementOptions = this.setupReplacemantOptionsToReturnNew();
        Object replaced = this.mongoOps.findAndReplace(hasId, obj, replacementOptions.returnNew(), this.getCollectionName());
        return (T)replaced;
    }

    private FindAndReplaceOptions setupReplacemantOptionsToReturnNew() {
        FindAndReplaceOptions replacementOptions = FindAndReplaceOptions.empty();
        replacementOptions.returnNew();
        return replacementOptions;
    }

    public T handleMongoDbIdAttribute(T data) {
        if (data instanceof Map) {
            ((Map)data).remove("_id");
        }
        return data;
    }

    public boolean delete(String key) {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)"identification.id").is((Object)key));
        DeleteResult result = this.mongoOps.remove(hasId, this.getCollectionName());
        return result.getDeletedCount() == 1L;
    }

    public void createCollectionIfNotExists(String collectionName) {
    }

    public void deleteCollection() {
        this.mongoOps.dropCollection(this.getCollectionName());
    }

    public T rawRetrieve(String key) {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)"identification.id").is((Object)key));
        Object result = this.mongoOps.findOne(hasId, this.TYPE, this.getCollectionName());
        if (result == null) {
            throw new ResourceNotFoundException("No Object for key '" + key + "' found in the database.");
        }
        result = this.handleMongoDbIdAttribute(result);
        return (T)result;
    }

    public File getFile(String idShortPath, String parentKey, Map<String, Object> objMap) {
        try {
            org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File fileSubmodelElement = org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File.createAsFacade(objMap);
            GridFSBucket bucket = MongoDBFileHelper.getGridFSBucket(this.client, this.config);
            String fileName = MongoDBFileHelper.constructFileName(parentKey, fileSubmodelElement, idShortPath);
            File file = new File(fileName);
            if (!MongoDBFileHelper.fileExists(bucket, fileName)) {
                fileName = MongoDBFileHelper.legacyFileName(parentKey, fileSubmodelElement, idShortPath);
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                bucket.downloadToStream(fileName, (OutputStream)fileOutputStream);
            }
            return file;
        }
        catch (IOException e) {
            throw new ResourceNotFoundException("The File Submodel Element does not contain a File");
        }
    }

    public String writeFile(String idShortPath, String parentKey, InputStream inputStream, ISubmodelElement element) {
        return MongoDBFileHelper.updateFileInDB(this.client, this.config, parentKey, inputStream, element, idShortPath);
    }

    public void deleteFile(Submodel submodel, String idShort) {
        MongoDBFileHelper.deleteAllFilesFromGridFsIfIsFileSubmodelElement(this.client, this.config, submodel, idShort);
    }

    public Collection<T> rawRetrieveAll() {
        Collection data = this.mongoOps.findAll(this.TYPE, this.getCollectionName());
        data = data.stream().map(this::handleMongoDbIdAttribute).collect(Collectors.toList());
        return data;
    }

    public Object getStorageConnection() {
        return this.mongoOps;
    }

    public MongoClient getClient() {
        return this.client;
    }
}

