/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.models.controlcomponent;

import org.eclipse.basyx.components.netcomm.NetworkReceiver;
import org.eclipse.basyx.components.netcomm.TCPServer;
import org.eclipse.basyx.models.controlcomponent.ExecutionOrder;
import org.eclipse.basyx.models.controlcomponent.ExecutionState;
import org.eclipse.basyx.models.controlcomponent.SimpleControlComponent;
import org.eclipse.basyx.vab.service.api.BaSyxService;

public class SimpleProxyControlComponent
extends SimpleControlComponent
implements NetworkReceiver,
BaSyxService {
    private static final long serialVersionUID = 1L;
    protected TCPServer tcpServer = null;
    protected String componentName = null;
    protected Thread serverThread = null;
    protected boolean endExecution = false;

    public SimpleProxyControlComponent(int serverPort) {
        this.tcpServer = new TCPServer(serverPort);
        this.tcpServer.addTCPMessageListener(this);
    }

    @Override
    public void onReceive(byte[] message) {
        String rxMessage = TCPServer.toString(message);
        if (rxMessage.equalsIgnoreCase(this.buildMessage(ExecutionState.IDLE))) {
            this.setExecutionState(ExecutionState.IDLE.getValue());
            return;
        }
        if (rxMessage.equalsIgnoreCase(this.buildMessage(ExecutionOrder.ABORT))) {
            this.setCommand(ExecutionOrder.ABORT.getValue().toLowerCase());
            return;
        }
        if (rxMessage.equalsIgnoreCase(this.buildMessage(ExecutionState.COMPLETE))) {
            if (!this.getExecutionState().equalsIgnoreCase(ExecutionState.EXECUTE.getValue())) {
                throw new RuntimeException("Semantic error detected");
            }
            this.finishState();
            return;
        }
        if (rxMessage.equalsIgnoreCase(this.buildMessage(ExecutionOrder.RESET))) {
            if (!this.getExecutionState().equalsIgnoreCase(ExecutionOrder.COMPLETE.getValue())) {
                throw new RuntimeException("Semantic error detected");
            }
            this.put("cmd", (Object)ExecutionOrder.RESET.getValue().toLowerCase());
            return;
        }
        if (rxMessage.equalsIgnoreCase("finishState")) {
            this.finishState();
            return;
        }
        throw new RuntimeException("Unexpected message received");
    }

    @Override
    protected String filterExecutionState(String newExecutionState) {
        super.filterExecutionState(newExecutionState);
        if (this.tcpServer == null) {
            return newExecutionState;
        }
        switch (ExecutionState.byValue(newExecutionState)) {
            case IDLE: {
                this.tcpServer.sendMessage(this.buildMessage(ExecutionState.IDLE));
                break;
            }
            case EXECUTE: {
                this.tcpServer.sendMessage(this.buildMessage(ExecutionState.EXECUTE));
                break;
            }
            case COMPLETE: {
                this.tcpServer.sendMessage(this.buildMessage(ExecutionState.COMPLETE));
                break;
            }
            case ABORTED: {
                this.tcpServer.sendMessage(this.buildMessage(ExecutionState.ABORTED));
                break;
            }
            case STOPPED: {
                this.tcpServer.sendMessage(this.buildMessage(ExecutionState.STOPPED));
                break;
            }
            case RESETTING: {
                this.tcpServer.sendMessage(this.buildMessage(ExecutionState.RESETTING));
                break;
            }
        }
        return newExecutionState;
    }

    @Override
    public String filterOperationMode(String newOperationMode) {
        if (this.tcpServer == null) {
            return newOperationMode;
        }
        this.tcpServer.sendMessage("opMode:" + newOperationMode);
        return newOperationMode;
    }

    public void start() {
        this.serverThread = new Thread(this.tcpServer);
        this.serverThread.start();
    }

    public void stop() {
        this.endExecution = true;
        this.tcpServer.close();
        this.tcpServer.closeServer();
        try {
            this.serverThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void waitFor() {
        try {
            this.serverThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public BaSyxService setName(String newName) {
        this.componentName = newName;
        return this;
    }

    public String getName() {
        return this.componentName;
    }

    public boolean hasEnded() {
        return this.endExecution;
    }

    private String buildMessage(ExecutionState state) {
        return "state:" + state.getValue().toLowerCase();
    }

    private String buildMessage(ExecutionOrder state) {
        return "state:" + state.getValue().toLowerCase();
    }
}

