/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.aas.active;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.basyx.tools.aas.active.VABModelTask;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class VABModelTaskGroup {
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> currentSchedule;
    private int updateInterval = 1000;
    private List<VABModelTask> tasks = new LinkedList<VABModelTask>();
    private IModelProvider modelProvider;

    public VABModelTaskGroup(IModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    public synchronized VABModelTaskGroup setModelProvider(IModelProvider newProvider) {
        this.modelProvider = newProvider;
        return this;
    }

    public synchronized VABModelTaskGroup addTask(VABModelTask task) {
        this.tasks.add(task);
        return this;
    }

    public synchronized VABModelTaskGroup setUpdateInterval(int newInterval) {
        this.updateInterval = newInterval;
        if (this.isRunning()) {
            this.stop();
            this.start();
        }
        return this;
    }

    public synchronized void start() {
        if (!this.isRunning()) {
            this.currentSchedule = this.executor.scheduleAtFixedRate(this::update, this.updateInterval, this.updateInterval, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.currentSchedule.cancel(false);
            this.currentSchedule = null;
        }
    }

    public synchronized boolean isRunning() {
        return this.currentSchedule != null;
    }

    protected synchronized void update() {
        for (VABModelTask task : this.tasks) {
            try {
                task.execute(this.modelProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void clear() {
        this.executor.shutdown();
        this.currentSchedule = null;
    }
}

